/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.acm.seguin.ide.common.EditorOperations;
import org.acm.seguin.uml.UMLPackage;

public class CenterDialog {
    private CenterDialog() {
    }

    public static void center(JDialog dialog, JFrame parent) {
        int y;
        int x;
        Dimension frameSize;
        Dimension dim = dialog.getPreferredSize();
        if (parent == null) {
            frameSize = Toolkit.getDefaultToolkit().getScreenSize();
            x = 0;
            y = 0;
        } else {
            frameSize = parent.getSize();
            Point loc = parent.getLocation();
            x = loc.x;
            y = loc.y;
        }
        dialog.setLocation(x += (frameSize.width - dim.width) / 2, y += (frameSize.height - dim.height) / 2);
    }

    public static void center(JDialog dialog) {
        EditorOperations eo = EditorOperations.get();
        if (eo == null) {
            CenterDialog.center(dialog, (JFrame)null);
        } else {
            CenterDialog.center(dialog, eo.getEditorFrame());
        }
    }

    public static void center(JDialog dialog, UMLPackage umlPackage) {
        if (umlPackage == null) {
            CenterDialog.center(dialog);
            return;
        }
        Container current = umlPackage.getParent();
        while (!(current instanceof JFrame)) {
            current = current.getParent();
        }
        CenterDialog.center(dialog, (JFrame)current);
    }
}

