/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.awt;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.acm.seguin.awt.CenterDialog;

public class ExceptionDialog
extends JDialog
implements ActionListener {
    public ExceptionDialog(Throwable thrown) {
        this(thrown, null, true);
    }

    public ExceptionDialog(Throwable thrown, Frame parent) {
        this(thrown, parent, true);
    }

    public ExceptionDialog(Throwable thrown, Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Exception thrown");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        JLabel sizer = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Dimension size = sizer.getPreferredSize();
        int scrollHeight = 6 * size.height;
        Dimension scrollSize = new Dimension(size.width, scrollHeight);
        JScrollPane messagePane = new JScrollPane(this.createPanel(this.untab(thrown.getMessage())));
        messagePane.setPreferredSize(scrollSize);
        messagePane.setSize(scrollSize);
        messagePane.setLocation(10, 10);
        this.getContentPane().add(messagePane);
        JScrollPane stackPane = new JScrollPane(this.createStackTrace(thrown));
        stackPane.setPreferredSize(scrollSize);
        stackPane.setSize(scrollSize);
        stackPane.setLocation(10, 20 + scrollHeight);
        this.getContentPane().add(stackPane);
        JButton ok = new JButton("OK");
        Dimension okSize = ok.getPreferredSize();
        ok.setSize(okSize);
        ok.setLocation((20 + size.width - okSize.width) / 2, 30 + scrollHeight * 2);
        this.getContentPane().add(ok);
        ok.addActionListener(this);
        int wide = 20 + size.width;
        int high = 90 + scrollHeight * 2;
        this.setSize(wide, high);
        CenterDialog.center(this);
    }

    public void actionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private JPanel createPanel(String value) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(value, "\n\r");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        JPanel result = new JPanel();
        result.setLayout(new GridLayout(list.size(), 1));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            JLabel label = new JLabel((String)iter.next());
            result.add(label);
        }
        return result;
    }

    private JPanel createStackTrace(Throwable thrown) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter output = new PrintWriter(stringWriter);
        thrown.printStackTrace(output);
        output.close();
        return this.createPanel(this.untab(stringWriter.toString()));
    }

    public static void main(String[] args) {
        new ExceptionDialog(new Exception("Here is\na six line\nerror\nmesage\nfor you to\nread.\n \nDo you enjoy?")).setVisible(true);
    }

    private String untab(String value) {
        StringBuffer buffer = new StringBuffer();
        int last = value.length();
        int ndx = 0;
        while (ndx < last) {
            if (value.charAt(ndx) == '\t') {
                buffer.append("        ");
            } else {
                buffer.append(value.charAt(ndx));
            }
            ++ndx;
        }
        return buffer.toString();
    }
}

