/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.awt;

import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import org.acm.seguin.awt.MoveItemAdapter;
import org.acm.seguin.awt.OrderableListModel;

public class OrderableList
extends JPanel {
    private JButton downButton;
    private JList list;
    private OrderableListModel olm;
    private JButton upButton;

    public OrderableList(Object[] data, ListCellRenderer render) {
        this.setLayout(null);
        this.olm = new OrderableListModel();
        this.olm.setData(data);
        this.list = new JList(this.olm);
        this.olm.setList(this.list);
        if (render != null) {
            this.list.setCellRenderer(render);
        }
        Dimension dim = this.list.getPreferredSize();
        this.list.setSize(dim);
        this.list.setLocation(10, 10);
        this.add(this.list);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(new MoveItemAdapter(this.olm, this.list, -1));
        Dimension buttonSize = this.upButton.getPreferredSize();
        this.upButton.setSize(buttonSize);
        int top = Math.max(10, 10 + dim.height / 2 - 3 * buttonSize.height / 2);
        int bottom = top + buttonSize.height;
        this.upButton.setLocation(dim.width + 20, top);
        this.add(this.upButton);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(new MoveItemAdapter(this.olm, this.list, 1));
        buttonSize = this.downButton.getPreferredSize();
        this.downButton.setSize(buttonSize);
        this.upButton.setSize(buttonSize);
        top = Math.max(bottom + 10, 10 + dim.height / 2 + buttonSize.height / 2);
        bottom = top + buttonSize.height;
        this.downButton.setLocation(dim.width + 20, top);
        this.add(this.downButton);
        Dimension panelSize = new Dimension(30 + dim.width + buttonSize.width, Math.max(10 + bottom, 20 + dim.height));
        this.setPreferredSize(panelSize);
        this.list.setLocation(10, (panelSize.height - dim.height) / 2);
    }

    public void setEnabled(boolean way) {
        super.setEnabled(way);
        this.list.setEnabled(way);
        this.upButton.setEnabled(way);
        this.downButton.setEnabled(way);
    }

    public Object[] getData() {
        return this.olm.getData();
    }

    public void addListDataListener(ListDataListener l) {
        this.olm.addListDataListener(l);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Object[] data = new Object[]{"one", "two", "three"};
        frame.getContentPane().add(new OrderableList(data, null));
        frame.pack();
        frame.show();
    }

    public void removeListDataListener(ListDataListener l) {
        this.olm.removeListDataListener(l);
    }

    public void resetModel(Object[] data) {
        this.olm = new OrderableListModel();
        this.olm.setData(data);
        this.list.setModel(this.olm);
    }
}

