/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;

public abstract class DirectoryTreeTraversal
implements Runnable {
    private File startingPoint;

    public DirectoryTreeTraversal(String init) {
        this.startingPoint = new File(init);
    }

    public void run() {
        if (this.startingPoint.exists()) {
            this.traverse(this.startingPoint);
        }
    }

    protected abstract boolean isTarget(File var1);

    protected boolean isAllowed(File currentDirectory) {
        return true;
    }

    protected void traverse(File current) {
        if (current.isDirectory()) {
            if (this.isAllowed(current)) {
                this.arriveAtDir(current);
                String[] list = current.list();
                int ndx = 0;
                while (ndx < list.length) {
                    this.traverse(new File(current, list[ndx]));
                    ++ndx;
                }
                this.leaveDir(current);
            }
        } else if (this.isTarget(current)) {
            this.visit(current);
        }
    }

    protected abstract void visit(File var1);

    protected void arriveAtDir(File currentFile) {
    }

    protected void leaveDir(File currentFile) {
    }
}

