/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.acm.seguin.awt.ExceptionPrinter;

public class FileCopy
implements Runnable {
    private File source;
    private File dest;
    private boolean noisy;

    public FileCopy(File src, File dst) {
        this.source = src;
        this.dest = dst;
        this.noisy = true;
    }

    public FileCopy(File src, File dst, boolean isNoisy) {
        this.source = src;
        this.dest = dst;
        this.noisy = isNoisy;
    }

    public synchronized void run() {
        try {
            if (this.noisy) {
                System.out.println("Copying from " + this.source.getCanonicalPath() + " to " + this.dest.getCanonicalPath());
            }
            InputStream fis = this.getInputStream();
            OutputStream fos = this.getOutputStream();
            int bufferSize = 32768;
            byte[] buffer = new byte[bufferSize];
            int bytesRead = bufferSize;
            while (bytesRead == bufferSize) {
                bytesRead = fis.read(buffer);
                fos.write(buffer, 0, bytesRead);
            }
            fos.close();
            fis.close();
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
    }

    protected synchronized InputStream getInputStream() throws IOException {
        return new FileInputStream(this.source);
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        File parent = this.dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        return new FileOutputStream(this.dest);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Syntax:  FileCopy source dest");
            return;
        }
        new FileCopy(new File(args[0]), new File(args[1])).run();
    }
}

