/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.util.FileSettings;

public class InplaceOutputStream
extends OutputStream {
    private File finalDestination;
    private File temporary;
    private FileOutputStream out;

    public InplaceOutputStream(File dest) throws IOException {
        this.finalDestination = dest;
        String parent = dest.getPath();
        if (!(parent != null && this.attempt(parent + File.separator + "inplace") || this.attempt("." + File.separator + "inplace") || this.attempt(new File(FileSettings.getRefactorySettingsRoot(), "inplace").toString()))) {
            throw new IOException("Unable to create the output file!");
        }
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        if (this.temporary.exists() && this.temporary.length() > 0L) {
            new FileCopy(this.temporary, this.finalDestination, false).run();
        }
        this.temporary.delete();
        this.out = null;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.flush();
    }

    public void write(int b) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(b, off, len);
    }

    protected void finalize() {
        if (this.out == null) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File createTempFile(String prefix, String suffix) {
        int ndx = 0;
        while (ndx < 1024) {
            double number = Math.random() * 1024.0 * 1024.0;
            long rounded = Math.round(number);
            File possible = new File(prefix + rounded + suffix);
            if (!possible.exists()) {
                return possible;
            }
            ++ndx;
        }
        return null;
    }

    private boolean attempt(String filepath) {
        try {
            this.temporary = this.createTempFile(filepath, ".java");
            this.temporary.delete();
            if (this.temporary.exists()) {
                return false;
            }
            this.out = new FileOutputStream(this.temporary);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }
}

