/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.text.MessageFormat;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.ASTAttribute;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ForceJavadocComments;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.ai.RequiredTags;
import org.acm.seguin.util.FileSettings;

public class ASTConstructorDeclaration
extends SimpleNode
implements JavaDocable {
    private JavaDocableImpl jdi;
    private ModifierHolder modifiers = new ModifierHolder();
    private String name;

    public ASTConstructorDeclaration(int id) {
        super(id);
        this.jdi = new JavaDocableImpl();
    }

    public ASTConstructorDeclaration(JavaParser p, int id) {
        super(p, id);
        this.jdi = new JavaDocableImpl();
    }

    public void setName(String newName) {
        this.name = newName.intern();
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public String getModifiersString(int code) {
        if (code == 1) {
            return this.modifiers.toString();
        }
        return this.modifiers.toStandardOrderString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    public boolean isExplicit() {
        return this.modifiers.isExplicit();
    }

    public boolean isFinal() {
        return this.modifiers.isFinal();
    }

    public boolean isInterface() {
        return this.modifiers.isInterface();
    }

    public boolean isNative() {
        return this.modifiers.isNative();
    }

    public boolean isPrivate() {
        return this.modifiers.isPrivate();
    }

    public boolean isProtected() {
        return this.modifiers.isProtected();
    }

    public boolean isPublic() {
        return this.modifiers.isPublic();
    }

    public boolean isRequired() {
        ForceJavadocComments fjc = new ForceJavadocComments();
        return this.jdi.isRequired() && fjc.isJavaDocRequired("method", this.modifiers);
    }

    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public boolean isStrict() {
        return this.modifiers.isStrict();
    }

    public boolean isSynchronized() {
        return this.modifiers.isSynchronized();
    }

    public boolean isTransient() {
        return this.modifiers.isTransient();
    }

    public boolean isVolatile() {
        return this.modifiers.isVolatile();
    }

    public void addJavaDocComponent(JavaDocComponent component) {
        this.jdi.addJavaDocComponent(component);
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public void finish() {
        JavadocTags tags = JavadocTags.get();
        Object[] nameArray = new Object[]{this.getName()};
        String msg = MessageFormat.format(tags.getConstructorDescr(), nameArray);
        this.jdi.require("", msg);
        int child = 0;
        if (this.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        ASTFormalParameters params = (ASTFormalParameters)this.jjtGetChild(child);
        int childCount = params.jjtGetNumChildren();
        String[] constructorParams = new String[childCount];
        int ndx = 0;
        while (ndx < childCount) {
            ASTFormalParameter nextParam = (ASTFormalParameter)params.jjtGetChild(ndx);
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)nextParam.jjtGetChild(1);
            this.jdi.require("@param", id.getName(), tags.getParamDescr());
            constructorParams[ndx] = id.getName();
            ++ndx;
        }
        this.jdi.sort("@param", constructorParams);
        if (this.jjtGetNumChildren() > child + 1 && this.jjtGetChild(child + 1) instanceof ASTNameList) {
            ASTNameList exceptions = (ASTNameList)this.jjtGetChild(child + 1);
            childCount = exceptions.jjtGetNumChildren();
            ndx = 0;
            while (ndx < childCount) {
                ASTName name = (ASTName)exceptions.jjtGetChild(ndx);
                this.jdi.require(tags.getExceptionTag(), name.getName(), tags.getExceptionDescr());
                ++ndx;
            }
        }
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        RequiredTags.getTagger().addTags(bundle, "method", this.getName(), this.jdi);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void printJavaDocComponents(PrintData printData) {
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        this.jdi.printJavaDocComponents(printData, bundle.getString("method.tags"));
    }

    public String toString() {
        return super.toString() + " [" + this.getModifiersString(1) + " " + this.getName() + "]";
    }
}

