/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.ASTLiteral;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.DescriptionPadder;
import org.acm.seguin.pretty.ForceJavadocComments;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.ai.RequiredTags;
import org.acm.seguin.util.FileSettings;

public class ASTEnumDeclaration
extends SimpleNode {
    private ModifierHolder modifiers = new ModifierHolder();
    private JavaDocableImpl jdi = new JavaDocableImpl();

    public ASTEnumDeclaration(int id) {
        super(id);
    }

    public ASTEnumDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public boolean isFinal() {
        return this.modifiers.isFinal();
    }

    public boolean isPrivate() {
        return this.modifiers.isPrivate();
    }

    public boolean isProtected() {
        return this.modifiers.isProtected();
    }

    public boolean isPublic() {
        return this.modifiers.isPublic();
    }

    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public String getModifiersString(int code) {
        if (code == 1) {
            return this.modifiers.toString();
        }
        return this.modifiers.toStandardOrderString();
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public boolean isRequired() {
        ForceJavadocComments fjc = new ForceJavadocComments();
        return this.jdi.isRequired() && fjc.isJavaDocRequired("field", this.modifiers);
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public String toString() {
        return super.toString() + " [" + this.getModifiersString(1) + "]";
    }

    public void addJavaDocComponent(JavaDocComponent component) {
        this.jdi.addJavaDocComponent(component);
    }

    public void printJavaDocComponents(PrintData printData) {
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        this.jdi.printJavaDocComponents(printData, bundle.getString("enum.tags"));
    }

    public void finish() {
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        this.jdi.require("", DescriptionPadder.find(bundle, "enum.descr"));
        ASTLiteral id = (ASTLiteral)this.jjtGetChild(1);
        RequiredTags.getTagger().addTags(bundle, "enum", id.getName(), this.jdi);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

