/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.ASTAttribute;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTTypeParameters;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ForceJavadocComments;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.ai.MethodAnalyzer;
import org.acm.seguin.pretty.ai.RequiredTags;
import org.acm.seguin.util.FileSettings;

public class ASTMethodDeclaration
extends SimpleNode
implements JavaDocable {
    private ModifierHolder modifiers = new ModifierHolder();
    private JavaDocableImpl jdi = new JavaDocableImpl();

    public ASTMethodDeclaration(int id) {
        super(id);
    }

    public ASTMethodDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    public boolean isExplicit() {
        return this.modifiers.isExplicit();
    }

    public boolean isFinal() {
        return this.modifiers.isFinal();
    }

    public boolean isInterface() {
        return this.modifiers.isInterface();
    }

    public boolean isNative() {
        return this.modifiers.isNative();
    }

    public boolean isPrivate() {
        return this.modifiers.isPrivate();
    }

    public boolean isProtected() {
        return this.modifiers.isProtected();
    }

    public boolean isPublic() {
        return this.modifiers.isPublic();
    }

    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public boolean isStrict() {
        return this.modifiers.isStrict();
    }

    public boolean isSynchronized() {
        return this.modifiers.isSynchronized();
    }

    public boolean isTransient() {
        return this.modifiers.isTransient();
    }

    public boolean isVolatile() {
        return this.modifiers.isVolatile();
    }

    public String getModifiersString(int code) {
        if (code == 1) {
            return this.modifiers.toString();
        }
        return this.modifiers.toStandardOrderString();
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public boolean isRequired() {
        ForceJavadocComments fjc = new ForceJavadocComments();
        return this.jdi.isRequired() && fjc.isJavaDocRequired("method", this.modifiers);
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public String toString() {
        return super.toString() + " [" + this.getModifiersString(1) + "]";
    }

    public void addJavaDocComponent(JavaDocComponent component) {
        this.jdi.addJavaDocComponent(component);
    }

    public void printJavaDocComponents(PrintData printData) {
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        this.jdi.printJavaDocComponents(printData, bundle.getString("method.tags"));
    }

    public void finish() {
        this.finish("");
    }

    public void finish(String className) {
        MethodAnalyzer ai = new MethodAnalyzer(this, this.jdi);
        ai.finish(className);
        FileSettings bundle = FileSettings.getSettings("Refactory", "pretty");
        int child = 0;
        if (this.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        if (this.jjtGetChild(child) instanceof ASTTypeParameters) {
            ++child;
        }
        ASTMethodDeclarator method = (ASTMethodDeclarator)this.jjtGetChild(child + 1);
        RequiredTags.getTagger().addTags(bundle, "method", method.getName(), this.jdi);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

