/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.SimpleNode;

public class ASTName
extends SimpleNode
implements Cloneable {
    private Vector name = new Vector();

    public ASTName(int id) {
        super(id);
    }

    public ASTName(JavaParser p, int id) {
        super(p, id);
    }

    public void setNamePart(int ndx, String value) {
        this.name.setElementAt(value, ndx);
    }

    public String getNamePart(int ndx) {
        if (ndx >= 0 && ndx < this.name.size()) {
            return (String)this.name.elementAt(ndx);
        }
        return null;
    }

    public String getName() {
        StringBuffer buf = new StringBuffer();
        Enumeration enumeration = this.name.elements();
        boolean first = true;
        while (enumeration.hasMoreElements()) {
            if (!first) {
                buf.append(".");
            }
            buf.append((String)enumeration.nextElement());
            first = false;
        }
        return buf.toString();
    }

    public int getNameSize() {
        return this.name.size();
    }

    public void insertNamePart(int ndx, String value) {
        this.name.insertElementAt(value, ndx);
    }

    public void addNamePart(String newName) {
        this.name.addElement(newName.intern());
    }

    public String toString() {
        return super.toString() + " [" + this.getName() + "]";
    }

    public void fromString(String input) {
        this.name.removeAllElements();
        StringTokenizer tok = new StringTokenizer(input, ".");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            this.name.addElement(next);
        }
    }

    public boolean equals(Object other) {
        ASTName otherName;
        if (other == this) {
            return true;
        }
        if (other instanceof ASTName && (otherName = (ASTName)other).getNameSize() == this.getNameSize()) {
            return this.startsWith(otherName);
        }
        return false;
    }

    public boolean startsWith(ASTName otherName) {
        if (otherName.getNameSize() > this.getNameSize()) {
            return false;
        }
        int last = Math.min(otherName.getNameSize(), this.getNameSize());
        int ndx = 0;
        while (ndx < last) {
            if (!this.getNamePart(ndx).equals(otherName.getNamePart(ndx))) {
                return false;
            }
            ++ndx;
        }
        return true;
    }

    public ASTName changeStartingPart(ASTName oldBase, ASTName newBase) {
        int start;
        ASTName result = new ASTName(0);
        int last = newBase.getNameSize();
        int ndx = 0;
        while (ndx < last) {
            result.addNamePart(newBase.getNamePart(ndx));
            ++ndx;
        }
        int end = this.getNameSize();
        int ndx2 = start = oldBase.getNameSize();
        while (ndx2 < end) {
            result.addNamePart(this.getNamePart(ndx2));
            ++ndx2;
        }
        return result;
    }

    public Object clone() {
        ASTName result = new ASTName(0);
        int last = this.getNameSize();
        int ndx = 0;
        while (ndx < last) {
            result.addNamePart(this.getNamePart(ndx));
            ++ndx;
        }
        return result;
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

