/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.util.Vector;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserTreeConstants;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.NamedToken;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Vector specials;

    public SimpleNode(int i) {
        this.id = i;
        this.specials = null;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        this.parser = p;
    }

    public int getID() {
        return this.id;
    }

    public Token getSpecial(String key) {
        if (this.specials == null || key == null) {
            return null;
        }
        int last = this.specials.size();
        int ndx = 0;
        while (ndx < last) {
            NamedToken named = (NamedToken)this.specials.elementAt(ndx);
            if (named.check(key)) {
                return named.getToken();
            }
            ++ndx;
        }
        return null;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    public void jjtInsertChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else {
            Node[] c = new Node[Math.max(this.children.length + 1, i + 1)];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            this.children = c;
        }
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public boolean hasAnyChildren() {
        return this.children != null && this.children.length > 0;
    }

    public void jjtDeleteChild(int i) {
        if (this.children == null || this.children.length < i || i < 0) {
            System.out.println("Skipping this delete operation");
        } else {
            Node[] c = new Node[this.children.length - 1];
            System.arraycopy(this.children, 0, c, 0, i);
            System.arraycopy(this.children, i + 1, c, i, this.children.length - i - 1);
            this.children = c;
        }
    }

    public void addSpecial(String key, Token value) {
        if (value == null) {
            return;
        }
        if (this.specials == null) {
            this.init();
        }
        this.specials.addElement(new NamedToken(key, value));
    }

    public void removeSpecial(String key) {
        if (this.specials == null || key == null) {
            return;
        }
        int last = this.specials.size();
        int ndx = 0;
        while (ndx < last) {
            NamedToken named = (NamedToken)this.specials.elementAt(ndx);
            if (named.check(key)) {
                this.specials.removeElementAt(ndx);
                return;
            }
            ++ndx;
        }
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JavaParserVisitor visitor, Object data) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.err.println(prefix + this.getClass().getName());
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + " ");
                }
                ++i;
            }
        }
        if (this.specials != null) {
            int last = this.specials.size();
            int ndx = 0;
            while (ndx < last) {
                NamedToken named = (NamedToken)this.specials.elementAt(ndx);
                System.err.println("special[" + ndx + "]=" + named);
                ++ndx;
            }
        }
    }

    public String dumpString(String prefix) {
        StringBuffer sb = new StringBuffer(prefix + this.getClass().getName());
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    sb.append(n.dumpString(prefix + " "));
                }
                ++i;
            }
        }
        if (this.specials != null) {
            int last = this.specials.size();
            int ndx = 0;
            while (ndx < last) {
                NamedToken named = (NamedToken)this.specials.elementAt(ndx);
                sb.append("special[" + ndx + "]=" + named);
                ++ndx;
            }
        }
        return sb.toString();
    }

    protected void init() {
        if (this.specials == null) {
            this.specials = new Vector();
        }
    }

    public boolean isRequired() {
        return false;
    }
}

