/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;
import org.acm.seguin.parser.ast.ASTAttribute;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTReferenceType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTTypeArguments;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.ASTVariance;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.FieldSize;

class FieldSizeLookAhead {
    private FieldSize fieldSize = new FieldSize();
    private int code;

    public FieldSizeLookAhead(int init) {
        this.code = init;
    }

    public FieldSize run(SimpleNode body) {
        int last = body.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < last) {
            SimpleNode child = (SimpleNode)body.jjtGetChild(ndx);
            if (child.jjtGetChild(0) instanceof ASTFieldDeclaration) {
                ASTFieldDeclaration field = (ASTFieldDeclaration)child.jjtGetChild(0);
                if (this.code != 2 || !this.isJavadocAttached(field)) {
                    int equalsLength = this.computeEqualsLength(field);
                    this.fieldSize.setMinimumEquals(equalsLength);
                }
            }
            ++ndx;
        }
        return this.fieldSize;
    }

    public int computeEqualsLength(ASTFieldDeclaration field) {
        int modifierLength = this.computeModifierLength(field);
        int typeLength = this.computeTypeLength(field);
        int nameLength = this.computeNameLength(field);
        int equalsLength = modifierLength + typeLength + nameLength;
        return equalsLength;
    }

    public int computeTypeLength(ASTFieldDeclaration field) {
        int child = 0;
        if (field.jjtGetChild(0) instanceof ASTAttribute) {
            child = 1;
        }
        ASTType typeNode = (ASTType)field.jjtGetChild(child);
        int typeLength = 0;
        if (typeNode.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitive = (ASTPrimitiveType)typeNode.jjtGetChild(0);
            typeLength += primitive.getName().length();
        } else if (typeNode.jjtGetChild(0) instanceof ASTReferenceType) {
            typeLength += this.computeReferenceTypeLength((ASTReferenceType)typeNode.jjtGetChild(0));
        } else {
            System.out.println("FieldSizeLookAhead.computeTypeLength(): ASTName: typeNode.jjtGetChild(0)=" + typeNode.jjtGetChild(0));
            ASTName name = (ASTName)typeNode.jjtGetChild(0);
            typeLength += name.getName().length();
        }
        this.fieldSize.setTypeLength(typeLength);
        return typeLength;
    }

    public int computeReferenceTypeLength(ASTReferenceType reference) {
        int typeLength = 0;
        int child = 0;
        if (reference.jjtGetChild(0) instanceof ASTAttribute) {
            child = 1;
        }
        if (reference.jjtGetChild(child) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitive = (ASTPrimitiveType)reference.jjtGetChild(child);
            typeLength += primitive.getName().length();
        } else {
            ASTName name = (ASTName)reference.jjtGetChild(child);
            typeLength += name.getName().length();
        }
        int last = reference.jjtGetNumChildren();
        int ndx = child + 1;
        while (ndx < last) {
            if (reference.jjtGetChild(ndx) instanceof ASTVariance) {
                ASTVariance variance = (ASTVariance)reference.jjtGetChild(ndx);
                typeLength += 2 + variance.getName().length();
            } else if (reference.jjtGetChild(ndx) instanceof ASTTypeArguments) {
                // empty if block
            }
            ++ndx;
        }
        return typeLength;
    }

    private boolean isJavadocAttached(ASTFieldDeclaration node) {
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        ASTType type = (ASTType)node.jjtGetChild(child);
        return this.hasJavadoc(node.getSpecial("static")) || this.hasJavadoc(node.getSpecial("transient")) || this.hasJavadoc(node.getSpecial("volatile")) || this.hasJavadoc(node.getSpecial("final")) || this.hasJavadoc(node.getSpecial("public")) || this.hasJavadoc(node.getSpecial("protected")) || this.hasJavadoc(node.getSpecial("private")) || this.hasJavadoc(this.getInitialToken(type));
    }

    private Token getInitialToken(ASTType top) {
        if (top.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitiveType = (ASTPrimitiveType)top.jjtGetChild(0);
            return primitiveType.getSpecial("primitive");
        }
        if (top.jjtGetChild(0) instanceof ASTReferenceType) {
            ASTReferenceType reference = (ASTReferenceType)top.jjtGetChild(0);
            if (reference.jjtGetChild(0) instanceof ASTPrimitiveType) {
                ASTPrimitiveType primitiveType = (ASTPrimitiveType)reference.jjtGetChild(0);
                return primitiveType.getSpecial("primitive");
            }
            ASTName name = (ASTName)reference.jjtGetChild(0);
            return name.getSpecial("id0");
        }
        System.out.println("FieldSizeLookAhead.getInitialToken(): ASTName: top.jjtGetChild(0)=" + top.jjtGetChild(0));
        ASTName name = (ASTName)top.jjtGetChild(0);
        return name.getSpecial("id0");
    }

    private int computeNameLength(ASTFieldDeclaration field) {
        int child = 0;
        if (field.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)field.jjtGetChild(1).jjtGetChild(child);
        int nameLength = id.getName().length();
        this.fieldSize.setNameLength(nameLength);
        return nameLength;
    }

    private int computeModifierLength(ASTFieldDeclaration field) {
        int fieldLength = field.getModifiersString(2).length();
        this.fieldSize.setModifierLength(fieldLength);
        return fieldLength;
    }

    private boolean hasJavadoc(Token tok) {
        Token current = tok;
        while (current != null) {
            if (current.kind == 12) {
                return true;
            }
            current = current.specialToken;
        }
        return false;
    }
}

