/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.StringTokenizer;
import org.acm.seguin.pretty.JavadocDescriptionPrinter;
import org.acm.seguin.pretty.PrintData;

public class JavaDocComponent {
    private int longestLength = 0;
    private String description = "";
    private boolean printed = false;
    private boolean required = false;
    private String type = "";

    public void setDescription(String newDescription) {
        if (newDescription != null) {
            this.description = newDescription;
        }
    }

    public void setLongestLength(int newLongestLength) {
        this.longestLength = newLongestLength;
    }

    public void setRequired(boolean req) {
        this.required = req;
    }

    public void setType(String newType) {
        if (newType != null) {
            this.type = newType;
            this.setLongestLength(this.type.length() + 2);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public int getLongestLength() {
        return this.longestLength;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void print(PrintData printData) {
        this.setPrinted(true);
        if (!printData.isCurrentSingle()) {
            printData.indent();
            if (!printData.isStarsAlignedWithSlash()) {
                printData.space();
            }
            printData.appendComment("*", 1);
        }
        if (printData.isSpaceBeforeAt() && !this.isDescription()) {
            printData.appendComment(" ", 1);
        }
        if (!this.isDescription()) {
            printData.appendComment(this.getType(), 1);
        }
        if (!this.isDescription() && printData.isJavadocLinedUp()) {
            int extra = this.getLongestLength() - this.getType().length();
            int ndx = 0;
            while (ndx < extra) {
                printData.appendComment(" ", 1);
                ++ndx;
            }
        }
        if (printData.isReformatComments() || !this.isDescription()) {
            int i = 0;
            while (i < printData.getJavadocIndent()) {
                printData.appendComment(" ", 1);
                ++i;
            }
        }
        this.printDescription(printData);
        if (!printData.isCurrentSingle()) {
            printData.newline();
        }
    }

    protected void setPrinted(boolean prn) {
        this.printed = prn;
    }

    protected void leaveDescription(PrintData printData) {
        StringBuffer sb = new StringBuffer(printData.getJavadocIndent());
        int i = 0;
        while (i < printData.getJavadocIndent()) {
            sb.append(" ");
            ++i;
        }
        String indent = sb.toString();
        StringTokenizer tok = new StringTokenizer(this.getDescription(), "\n\r");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken();
            if (!first) {
                printData.indent();
                if (!printData.isStarsAlignedWithSlash()) {
                    printData.space();
                }
                printData.appendComment("*", 1);
                printData.appendComment(indent, 1);
            }
            printData.appendComment(nextToken, 1);
            first = false;
        }
    }

    protected void printDescription(PrintData printData) {
        int indent = 0;
        indent = this.getType().length() == 0 ? printData.getJavadocIndent() : printData.getTaggedJavadocDescription();
        this.wordwrapDescription(printData, indent);
    }

    protected void wordwrapDescription(PrintData printData, int indent) {
        JavadocDescriptionPrinter jdp = new JavadocDescriptionPrinter(printData, this.getDescription(), indent);
        jdp.run();
    }

    boolean isDescription() {
        return this.getType().length() == 0;
    }
}

