/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.NamedJavaDocComponent;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class JavaDocableImpl
implements JavaDocable {
    private Vector docs = new Vector();
    private boolean printed = false;

    public boolean isRequired() {
        return !this.printed;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public void addJavaDocComponent(JavaDocComponent component) {
        if (component != null) {
            this.docs.addElement(component);
        }
    }

    public void sort(String type, String[] names) {
        int ndx;
        Vector newDocs = new Vector();
        Vector typeDocs = new Vector();
        int ndx2 = 0;
        while (ndx2 < this.docs.size()) {
            NamedJavaDocComponent jdc;
            Object next = this.docs.elementAt(ndx2);
            if (next instanceof NamedJavaDocComponent && (jdc = (NamedJavaDocComponent)next).getType().equalsIgnoreCase(type)) {
                typeDocs.add(next);
            } else {
                newDocs.add(next);
            }
            ++ndx2;
        }
        boolean[] added = new boolean[typeDocs.size()];
        int i = 0;
        while (i < names.length) {
            ndx = 0;
            while (ndx < typeDocs.size()) {
                NamedJavaDocComponent jdc = (NamedJavaDocComponent)typeDocs.elementAt(ndx);
                if (jdc.getID().equals(names[i])) {
                    newDocs.add(jdc);
                    added[ndx] = true;
                }
                ++ndx;
            }
            ++i;
        }
        ndx = 0;
        while (ndx < typeDocs.size()) {
            if (!added[ndx]) {
                newDocs.add(typeDocs.elementAt(ndx));
            }
            ++ndx;
        }
        this.docs = newDocs;
    }

    public void printJavaDocComponents(PrintData printData) {
        this.printJavaDocComponents(printData, "");
    }

    public void printJavaDocComponents(PrintData printData, String order) {
        this.printed = true;
        if (this.docs.size() == 0) {
            return;
        }
        this.setLongest(this.getLongest());
        if (!printData.isLineIndented()) {
            printData.indent();
        }
        int loop = printData.getJavadocStarCount() - 2;
        printData.appendComment("/**", 1);
        int ndx = 0;
        while (ndx < loop) {
            printData.appendComment("*", 1);
            ++ndx;
        }
        boolean onSingleLine = this.isOnSingleLine(printData);
        if (!onSingleLine) {
            printData.newline();
        }
        this.print(printData, order, onSingleLine);
        if (!onSingleLine) {
            printData.indent();
        }
        if (!printData.isStarsAlignedWithSlash()) {
            printData.space();
        }
        int ndx2 = 0;
        while (ndx2 < loop) {
            printData.appendComment("*", 1);
            ++ndx2;
        }
        printData.appendComment("*/", 1);
        printData.newline();
        this.docs = new Vector();
    }

    public void finish() {
    }

    public boolean contains(String type) {
        int last = this.docs.size();
        boolean found = false;
        int ndx = 0;
        while (ndx < last) {
            JavaDocComponent jdc = (JavaDocComponent)this.docs.elementAt(ndx);
            String typeName = jdc.getType();
            if (typeName.equalsIgnoreCase(type)) {
                jdc.setRequired(true);
                found = true;
                if (typeName.equals("param") || typeName.equals("return") || typeName.equals("exception") || typeName.equals("throws") || typeName.equals("")) {
                    return true;
                }
            }
            ++ndx;
        }
        return found;
    }

    public boolean contains(String type, String id) {
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            NamedJavaDocComponent jdc;
            Object next = this.docs.elementAt(ndx);
            if (next instanceof NamedJavaDocComponent && (jdc = (NamedJavaDocComponent)next).getType().equalsIgnoreCase(type) && jdc.getID().equals(id)) {
                jdc.setRequired(true);
                return true;
            }
            ++ndx;
        }
        return false;
    }

    public void require(String tag, String descr) {
        if (!this.contains(tag)) {
            JavaDocComponent jdc = new JavaDocComponent();
            jdc.setType(tag);
            jdc.setDescription(descr);
            this.addJavaDocComponent(jdc);
            jdc.setRequired(true);
        }
    }

    public void require(String tag, String id, String descr) {
        if (!this.contains(tag, id)) {
            NamedJavaDocComponent jdc = new NamedJavaDocComponent();
            jdc.setType(tag);
            jdc.setID(id);
            jdc.setDescription(descr);
            this.addJavaDocComponent(jdc);
            jdc.setRequired(true);
        }
    }

    private void setLongest(int length) {
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            ((JavaDocComponent)this.docs.elementAt(ndx)).setLongestLength(length);
            ++ndx;
        }
    }

    private int getLongest() {
        int longest = 0;
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            int next = ((JavaDocComponent)this.docs.elementAt(ndx)).getLongestLength();
            longest = Math.max(next, longest);
            ++ndx;
        }
        return longest;
    }

    private boolean isDescription(JavaDocComponent current) {
        return current.getType().length() == 0;
    }

    private boolean isTagRequired(String tag) {
        try {
            FileSettings bundle = FileSettings.getRefactoryPrettySettings();
            bundle.getString(tag + ".descr");
            return true;
        }
        catch (MissingSettingsException mse) {
            return false;
        }
    }

    private boolean isOnSingleLine(PrintData printData) {
        if (!printData.isAllowSingleLineJavadoc()) {
            return false;
        }
        if (this.docs.size() > 1) {
            return false;
        }
        JavaDocComponent single = (JavaDocComponent)this.docs.elementAt(0);
        if (!single.isDescription()) {
            return false;
        }
        String text = single.getDescription();
        if (text.length() > printData.getJavadocWordWrapMaximum()) {
            return false;
        }
        return (text = text.toUpperCase()).indexOf("<P>") < 0 && text.indexOf("<BR") < 0 && text.indexOf("<DL") < 0 && text.indexOf("<OL") < 0 && text.indexOf("<UL") < 0;
    }

    private void print(PrintData printData, String order, boolean singleLine) {
        StringTokenizer tok = new StringTokenizer(order, ", \t\r\n");
        this.printDescription(printData, singleLine);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            boolean isRequired = this.isTagRequired(next);
            this.tagPass("@" + next, printData, isRequired);
        }
        this.finalPass(printData);
    }

    private void tagPass(String next, PrintData printData, boolean req) {
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            boolean required;
            JavaDocComponent current = (JavaDocComponent)this.docs.elementAt(ndx);
            boolean now = next.equals(current.getType());
            boolean bl = required = !req || current.isRequired();
            if (now) {
                if (required) {
                    this.printCurrentTag(current, printData, false, false);
                } else if (printData.isKeepErroneousJavadocTags()) {
                    current.setType(current.getType() + "-error");
                } else {
                    current.setPrinted(true);
                }
            }
            ++ndx;
        }
    }

    private void printDescription(PrintData printData, boolean singleLine) {
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            JavaDocComponent current = (JavaDocComponent)this.docs.elementAt(ndx);
            if (current.getType().equals("")) {
                String descr = current.getDescription();
                if (JavadocTokenizer.hasContent(descr)) {
                    this.printCurrentTag(current, printData, last == 1, singleLine);
                }
                current.setPrinted(true);
            }
            ++ndx;
        }
    }

    private void finalPass(PrintData printData) {
        int last = this.docs.size();
        int ndx = 0;
        while (ndx < last) {
            JavaDocComponent current = (JavaDocComponent)this.docs.elementAt(ndx);
            if (!current.isPrinted()) {
                this.printCurrentTag(current, printData, false, false);
            }
            ++ndx;
        }
    }

    private void printCurrentTag(JavaDocComponent current, PrintData printData, boolean onlyDescription, boolean singleLine) {
        printData.setCurrentIsSingle(singleLine);
        current.print(printData);
        printData.setCurrentIsSingle(false);
        if (!onlyDescription && this.isDescription(current)) {
            this.printSpaceAfterDescription(printData);
        }
    }

    private void printSpaceAfterDescription(PrintData printData) {
        printData.indent();
        if (!printData.isStarsAlignedWithSlash()) {
            printData.space();
        }
        printData.appendComment("*", 1);
        printData.newline();
    }
}

