/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.PrintData;

public class JavadocDescriptionPrinter {
    private PrintData printData;
    private StringBuffer buffer;
    private int indent;
    private int mode;
    private boolean newline;
    private int owedLines;
    private boolean withinID;
    private static int NORMAL = 0;
    private static int PARA = 1;
    private static int LIST = 2;
    private static int END_LIST = 3;
    private static int TABLE = 4;
    private static int END_TAG = 5;
    private static int LINE_BREAK = 6;
    private static int PREFORMATTED = 7;

    public JavadocDescriptionPrinter(PrintData data, String description) {
        this.printData = data;
        this.buffer = new StringBuffer(description);
        this.indent = this.printData.getJavadocIndent();
        this.newline = false;
        this.withinID = false;
        this.mode = NORMAL;
    }

    public JavadocDescriptionPrinter(PrintData data, String description, int initIndent) {
        this.printData = data;
        this.buffer = new StringBuffer(description);
        this.indent = initIndent;
        this.withinID = false;
    }

    public void run() {
        if (this.printData.isReformatComments()) {
            int MIN = this.printData.getJavadocWordWrapMinimum();
            int MAX = this.printData.getJavadocWordWrapMaximum();
            JavadocTokenizer tok = new JavadocTokenizer(this.buffer.toString());
            this.mode = NORMAL;
            boolean first = true;
            while (tok.hasNext()) {
                Token nextToken = tok.next();
                first = this.printToken(nextToken, MIN, MAX, first);
            }
        } else {
            this.maintainCurrentFormat();
        }
    }

    protected void indent() {
        if (this.printData.isCurrentSingle()) {
            return;
        }
        this.newline = true;
        this.printData.indent();
        if (!this.printData.isStarsAlignedWithSlash()) {
            this.printData.space();
        }
        this.printData.appendComment("*", 1);
        if (this.printData.isReformatComments() && this.mode != PREFORMATTED) {
            int ndx = 0;
            while (ndx < this.indent) {
                this.printData.space();
                ++ndx;
            }
        }
    }

    protected boolean startMode(String token) {
        if (this.startsWith(token, "<PRE") || this.startsWith(token, "<CODE")) {
            this.mode = PREFORMATTED;
        } else if (this.startsWith(token, "</PRE") || this.startsWith(token, "</CODE")) {
            this.mode = NORMAL;
        } else if (this.startsWith(token, "<P")) {
            this.mode = PARA;
        } else if (this.startsWith(token, "<BR")) {
            this.mode = LINE_BREAK;
        } else {
            if (this.startsWith(token, "<UL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "<OL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "<DL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "</UL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</OL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</DL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "<LI")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(token, "<DD")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(token, "<DT")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(token, "<TABLE")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "<TR")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "<TD")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "<TH")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(token, "</TABLE")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</TR")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</TD")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</TH")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(token, "</") && !this.newline) {
                this.mode = END_TAG;
            }
        }
        return false;
    }

    protected boolean spaceRequired(Token tok) {
        String token = tok.image.toUpperCase();
        if (this.startsWithThenSpace(token, "<PRE")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<P")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<BR")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<UL")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<OL")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<DL")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<LI")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<DD")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<DT")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<TABLE")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<TR")) {
            return true;
        }
        if (this.startsWithThenSpace(token, "<TD")) {
            return true;
        }
        return this.startsWithThenSpace(token, "<TH");
    }

    protected boolean endMode(String token) {
        if (this.mode == END_TAG) {
            this.mode = NORMAL;
            this.printData.space();
            return true;
        }
        if (this.mode == PARA) {
            this.mode = NORMAL;
            this.indent();
            this.indent();
            return true;
        }
        if (this.mode == LINE_BREAK) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        if (this.mode == LIST) {
            this.mode = NORMAL;
        }
        if (this.mode == END_LIST) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        if (this.mode == TABLE) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        return false;
    }

    protected boolean startsWith(String have, String want) {
        return have.toUpperCase().startsWith(want);
    }

    protected boolean startsWithThenSpace(String have, String want) {
        return have.toUpperCase().startsWith(want) && have.length() == want.length();
    }

    private boolean printToken(Token nextToken, int MIN, int MAX, boolean isFirst) {
        if (nextToken.kind == 2) {
            this.newline = false;
            if (nextToken.image.equals("$Id:")) {
                this.withinID = true;
            }
            int length = nextToken.image.length();
            if (!this.withinID && this.printData.getLineLength() > MIN && this.printData.getLineLength() + length > MAX && this.mode != PREFORMATTED) {
                this.indent();
                this.newline = true;
            }
            this.newline = nextToken.image.charAt(0) == '<' ? this.startMode(nextToken.image.toUpperCase()) : false;
            if (nextToken.image.equals("$")) {
                this.withinID = false;
            }
            if (this.newline && this.indent == 0 && nextToken.image.startsWith("/")) {
                this.printData.space();
            }
            this.printData.appendComment(nextToken.image, 1);
            if (this.spaceRequired(nextToken)) {
                this.printData.space();
            }
            if (nextToken.image.charAt(nextToken.image.length() - 1) == '>') {
                this.newline = this.endMode(nextToken.image) || this.newline;
            }
            return this.newline;
        }
        if (this.mode != PREFORMATTED) {
            if (!isFirst) {
                this.printData.space();
                return true;
            }
        } else if (nextToken.kind == 0) {
            this.printData.appendComment(nextToken.image, 1);
        } else {
            this.indent();
        }
        return isFirst;
    }

    private void maintainCurrentFormat() {
        JavadocTokenizer tok = new JavadocTokenizer(this.buffer.toString());
        this.owedLines = 0;
        Token last = null;
        Token current = tok.next();
        while (current.kind != 2) {
            last = current;
            if (!tok.hasNext()) {
                return;
            }
            current = tok.next();
        }
        if (last != null && last.kind != 1) {
            this.mcfOutputToken(last, this.printData);
        }
        this.mcfOutputToken(current, this.printData);
        while (tok.hasNext()) {
            Token nextToken = tok.next();
            this.mcfOutputToken(nextToken, this.printData);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mcfOutputToken(Token nextToken, PrintData printData) {
        block1: {
            if (nextToken.kind != 1) ** GOTO lbl6
            ++this.owedLines;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.indent();
                --this.owedLines;
lbl6:
                // 2 sources

                ** while (this.owedLines > 0)
            }
lbl7:
            // 1 sources

            printData.appendComment(nextToken.image, 1);
        }
    }
}

