/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class JavadocTags {
    private boolean debug = false;
    private String exceptionDescr = "";
    private String exceptionTag;
    private String paramDescr = "";
    private String returnDescr = "";
    private String constructorDescr;
    private static JavadocTags singleton = null;

    private JavadocTags() {
    }

    public void setDebug(boolean way) {
        this.debug = way;
    }

    public void setExceptionDescr(String value) {
        this.exceptionDescr = value == null ? "" : value;
    }

    public void setExceptionTag(String value) {
        this.exceptionTag = value == null || value.length() == 0 || value.equals("@") ? "exception" : (value.charAt(0) == '@' ? value.substring(1) : value);
    }

    public void setParamDescr(String value) {
        this.paramDescr = value == null ? "" : value;
    }

    public void setReturnDescr(String value) {
        this.returnDescr = value == null ? "" : value;
    }

    public String getExceptionDescr() {
        return this.exceptionDescr;
    }

    public String getExceptionTag() {
        return "@" + this.exceptionTag;
    }

    public String getParamDescr() {
        return this.paramDescr;
    }

    public String getReturnDescr() {
        return this.returnDescr;
    }

    public boolean isExceptionTag(String name) {
        String temp = name;
        if (name.charAt(0) == '@') {
            temp = name.substring(1);
        }
        return this.exceptionTag.equals(temp) || temp.equals("exception") || temp.equals("throws");
    }

    private boolean isDebug() {
        return this.debug;
    }

    public void reload() {
        FileSettings bundle = FileSettings.getRefactoryPrettySettings();
        try {
            this.setExceptionTag(bundle.getString("exception.tag.name"));
        }
        catch (MissingSettingsException mse) {
            this.setExceptionTag("exception");
        }
        try {
            this.setExceptionDescr(bundle.getString("exception.descr"));
        }
        catch (MissingSettingsException mse) {
            this.setExceptionDescr("Description of the exception");
        }
        try {
            this.setParamDescr(bundle.getString("param.descr"));
        }
        catch (MissingSettingsException mse) {
            this.setParamDescr("Description of the parameter");
        }
        try {
            this.setReturnDescr(bundle.getString("return.descr"));
        }
        catch (MissingSettingsException mse) {
            this.setReturnDescr("Description of the return value");
        }
        try {
            this.setConstructorDescr(bundle.getString("constructor.descr"));
        }
        catch (MissingSettingsException mse) {
            this.setConstructorDescr("Constructor for the {0} class");
        }
    }

    public static JavadocTags get() {
        if (singleton == null) {
            singleton = new JavadocTags();
            singleton.reload();
        }
        return singleton;
    }

    public String getConstructorDescr() {
        return this.constructorDescr;
    }

    public void setConstructorDescr(String value) {
        this.constructorDescr = value == null ? "" : value;
    }
}

