/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.PrintWriter;
import java.util.Vector;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class LineQueue {
    protected int lineNumber;
    private Vector list;
    private PrintWriter output;
    private int absoluteSpace;
    private int incrementalSpace;
    private boolean ownline;
    private boolean sharedIncremental;
    private boolean ownlineCode;
    private StringBuffer buffer;
    private String endOfLine;

    public LineQueue(PrintWriter init) {
        String temp;
        this.output = init;
        this.list = new Vector();
        this.buffer = new StringBuffer();
        FileSettings bundle = FileSettings.getRefactoryPrettySettings();
        try {
            this.absoluteSpace = bundle.getInteger("singleline.comment.absoluteindent");
        }
        catch (MissingSettingsException mse) {
            this.absoluteSpace = 0;
        }
        try {
            this.incrementalSpace = bundle.getInteger("singleline.comment.incrementalindent");
        }
        catch (MissingSettingsException mse) {
            this.incrementalSpace = 0;
        }
        try {
            this.ownline = bundle.getBoolean("singleline.comment.ownline");
        }
        catch (MissingSettingsException mse) {
            this.ownline = true;
        }
        try {
            temp = bundle.getString("singleline.comment.indentstyle.shared");
            this.sharedIncremental = temp.equalsIgnoreCase("incremental");
        }
        catch (MissingSettingsException mse) {
            this.sharedIncremental = true;
        }
        try {
            temp = bundle.getString("singleline.comment.indentstyle.ownline");
            this.ownlineCode = temp.equalsIgnoreCase("code");
        }
        catch (MissingSettingsException mse) {
            this.ownlineCode = true;
        }
        try {
            temp = bundle.getString("end.line");
            this.endOfLine = temp.equalsIgnoreCase("CRNL") ? "\r\n" : (temp.equalsIgnoreCase("CR") ? "\r" : "\n");
        }
        catch (MissingSettingsException mse) {
            this.endOfLine = "\n";
        }
        this.lineNumber = 1;
    }

    public void setAbsoluteCommentSpacing(int value) {
        this.absoluteSpace = value;
    }

    public void setIncrementalCommentSpacing(int value) {
        this.incrementalSpace = value;
    }

    public void setOwnline(boolean value) {
        this.ownline = value;
    }

    public void setSharedIncremental(boolean value) {
        this.sharedIncremental = value;
    }

    public void setOwnlineCode(boolean value) {
        this.ownlineCode = value;
    }

    public int getCurrentLine() {
        return this.lineNumber;
    }

    public void println(String value) {
        if (value.length() > 0) {
            this.flush();
        }
        this.list.addElement(value);
    }

    public void appendSingleLineComment(String comment, String prefix) {
        if (this.list.size() > 0) {
            if (this.ownline) {
                this.list.insertElementAt(this.makeLine(prefix, comment), 1);
                this.flushFirstLine();
            } else {
                this.updateLine(comment, prefix);
            }
        } else {
            this.println(this.makeLine(prefix, comment));
        }
        this.flushFirstLine();
    }

    public void appendCategoryComment(String comment, String prefix) {
        if (this.list.size() > 0) {
            String first = (String)this.list.elementAt(0);
            if (first.length() > 0) {
                this.list.insertElementAt(prefix + comment, 1);
                this.flushFirstLine();
            } else {
                this.list.insertElementAt(prefix + comment, 0);
            }
        } else {
            this.println(prefix + comment);
        }
        this.flushFirstLine();
    }

    public void flushFirstLine() {
        if (this.list.size() > 0) {
            this.writeln((String)this.list.elementAt(0));
            this.list.removeElementAt(0);
        }
    }

    public void flush() {
        int last = this.list.size();
        int ndx = 0;
        while (ndx < last) {
            this.writeln((String)this.list.elementAt(ndx));
            ++ndx;
        }
        this.list.removeAllElements();
        this.output.flush();
    }

    protected PrintWriter getOutput() {
        return this.output;
    }

    protected void writeln(String value) {
        this.buffer.setLength(0);
        this.buffer.append(value);
        int length = value.length();
        while (length > 0 && Character.isWhitespace(this.buffer.charAt(length - 1))) {
            this.buffer.setLength(--length);
        }
        this.output.print(this.buffer.toString());
        this.output.print(this.endOfLine);
        ++this.lineNumber;
    }

    private void updateLine(String comment, String prefix) {
        String first = (String)this.list.elementAt(0);
        if (first.length() == 0) {
            this.list.setElementAt(this.makeLine(prefix, comment), 0);
            return;
        }
        if (!this.sharedIncremental) {
            this.list.setElementAt(this.makeLine(first, comment), 0);
            return;
        }
        StringBuffer buffer = new StringBuffer(first);
        int ndx = 0;
        while (ndx < this.incrementalSpace) {
            buffer.append(" ");
            ++ndx;
        }
        buffer.append(comment);
        this.list.setElementAt(buffer.toString(), 0);
    }

    private String makeLine(String prefix, String comment) {
        boolean indent;
        if (prefix.length() == 0) {
            return comment;
        }
        String trim = prefix.trim();
        boolean hasNoCode = trim == null || trim.length() == 0;
        boolean bl = indent = hasNoCode && !this.ownlineCode || !hasNoCode && !this.sharedIncremental;
        if (indent) {
            StringBuffer buffer = !hasNoCode ? new StringBuffer(prefix) : new StringBuffer();
            while (buffer.length() < this.absoluteSpace) {
                buffer.append(" ");
            }
            buffer.append(comment);
            return buffer.toString();
        }
        return prefix + comment;
    }
}

