/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.ast.ASTBlockStatement;
import org.acm.seguin.parser.ast.ASTLocalVariableDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTReferenceType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTTypeArguments;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.ASTVariance;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.FieldSize;

class LocalVariableLookAhead {
    private FieldSize size = new FieldSize();

    public FieldSize run(SimpleNode body) {
        int last = body.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < last) {
            SimpleNode child = (SimpleNode)body.jjtGetChild(ndx);
            if (child instanceof ASTBlockStatement && child.jjtGetChild(0) instanceof ASTLocalVariableDeclaration) {
                ASTLocalVariableDeclaration localVariable = (ASTLocalVariableDeclaration)child.jjtGetChild(0);
                int equalsLength = this.computeEqualsLength(localVariable);
                this.size.setMinimumEquals(equalsLength);
            }
            ++ndx;
        }
        return this.size;
    }

    public int computeEqualsLength(ASTLocalVariableDeclaration localVariable) {
        int modifierLength = this.computeModifierLength(localVariable);
        int typeLength = this.computeTypeLength(localVariable);
        int nameLength = this.computeNameLength(localVariable);
        int equalsLength = modifierLength + typeLength + nameLength;
        return equalsLength;
    }

    public int computeTypeLength(SimpleNode localVariable) {
        ASTType typeNode = (ASTType)localVariable.jjtGetChild(0);
        int typeLength = 0;
        if (typeNode.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitive = (ASTPrimitiveType)typeNode.jjtGetChild(0);
            typeLength += primitive.getName().length();
        } else if (typeNode.jjtGetChild(0) instanceof ASTReferenceType) {
            typeLength += this.computeReferenceTypeLength((ASTReferenceType)typeNode.jjtGetChild(0));
        } else {
            System.out.println("LocalVariableLookAhead.computeTypeLength(): ASTName: typeNode.jjtGetChild(0)=" + typeNode.jjtGetChild(0));
            ASTName name = (ASTName)typeNode.jjtGetChild(0);
            typeLength += name.getName().length();
        }
        this.size.setTypeLength(typeLength);
        return typeLength;
    }

    public int computeReferenceTypeLength(ASTReferenceType reference) {
        int typeLength = 0;
        if (reference.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitive = (ASTPrimitiveType)reference.jjtGetChild(0);
            typeLength += primitive.getName().length();
        } else {
            ASTName name = (ASTName)reference.jjtGetChild(0);
            typeLength += name.getName().length();
        }
        int last = reference.jjtGetNumChildren();
        int ndx = 1;
        while (ndx < last) {
            if (reference.jjtGetChild(ndx) instanceof ASTVariance) {
                ASTVariance variance = (ASTVariance)reference.jjtGetChild(ndx);
                typeLength += 2 + variance.getName().length();
            } else if (reference.jjtGetChild(ndx) instanceof ASTTypeArguments) {
                // empty if block
            }
            ++ndx;
        }
        return typeLength;
    }

    private int computeModifierLength(ASTLocalVariableDeclaration localVariable) {
        int modifierLength = localVariable.isUsingFinal() ? 6 : 0;
        this.size.setModifierLength(modifierLength);
        return modifierLength;
    }

    private int computeNameLength(ASTLocalVariableDeclaration localVariable) {
        ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)localVariable.jjtGetChild(1).jjtGetChild(0);
        int nameLength = id.getName().length();
        this.size.setNameLength(nameLength);
        return nameLength;
    }
}

