/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.Serializable;

public class ModifierHolder
implements Serializable {
    private int modifiers = 0;
    protected static int ABSTRACT = 1;
    protected static int EXPLICIT = 2;
    protected static int FINAL = 4;
    protected static int INTERFACE = 8;
    protected static int NATIVE = 16;
    protected static int PRIVATE = 32;
    protected static int PROTECTED = 64;
    protected static int PUBLIC = 128;
    protected static int STATIC = 256;
    protected static int STRICT = 512;
    protected static int SYNCHRONIZED = 1024;
    protected static int TRANSIENT = 2048;
    protected static int VOLATILE = 4096;
    protected static int STRICTFP = 8192;
    protected static String[] names = new String[]{"abstract", "explicit", "final", "interface", "native", "private", "protected", "public", "static", "strict", "strictfp", "synchronized", "transient", "volatile"};

    public void setPrivate(boolean value) {
        this.setCode(value, PRIVATE);
    }

    public void setProtected(boolean value) {
        this.setCode(value, PROTECTED);
    }

    public void setPublic(boolean value) {
        this.setCode(value, PUBLIC);
    }

    public void setAbstract(boolean value) {
        this.setCode(value, ABSTRACT);
    }

    public void setSynchronized(boolean value) {
        this.setCode(value, SYNCHRONIZED);
    }

    public void setStatic(boolean value) {
        this.setCode(value, STATIC);
    }

    public boolean isAbstract() {
        return (this.modifiers & ABSTRACT) != 0;
    }

    public boolean isExplicit() {
        return (this.modifiers & EXPLICIT) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & FINAL) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & INTERFACE) != 0;
    }

    public boolean isNative() {
        return (this.modifiers & NATIVE) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & PRIVATE) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & PROTECTED) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & PUBLIC) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & STATIC) != 0;
    }

    public boolean isStrict() {
        return (this.modifiers & STRICT) != 0;
    }

    public boolean isStrictFP() {
        return (this.modifiers & STRICTFP) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & SYNCHRONIZED) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & TRANSIENT) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & VOLATILE) != 0;
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public void add(String mod) {
        if (mod == null || mod.length() == 0) {
            return;
        }
        if (mod.equalsIgnoreCase(names[0])) {
            this.modifiers |= ABSTRACT;
        } else if (mod.equalsIgnoreCase(names[1])) {
            this.modifiers |= EXPLICIT;
        } else if (mod.equalsIgnoreCase(names[2])) {
            this.modifiers |= FINAL;
        } else if (mod.equalsIgnoreCase(names[3])) {
            this.modifiers |= INTERFACE;
        } else if (mod.equalsIgnoreCase(names[4])) {
            this.modifiers |= NATIVE;
        } else if (mod.equalsIgnoreCase(names[5])) {
            this.modifiers |= PRIVATE;
        } else if (mod.equalsIgnoreCase(names[6])) {
            this.modifiers |= PROTECTED;
        } else if (mod.equalsIgnoreCase(names[7])) {
            this.modifiers |= PUBLIC;
        } else if (mod.equalsIgnoreCase(names[8])) {
            this.modifiers |= STATIC;
        } else if (mod.equalsIgnoreCase(names[9])) {
            this.modifiers |= STRICT;
        } else if (mod.equalsIgnoreCase(names[10])) {
            this.modifiers |= STRICTFP;
        } else if (mod.equalsIgnoreCase(names[11])) {
            this.modifiers |= SYNCHRONIZED;
        } else if (mod.equalsIgnoreCase(names[12])) {
            this.modifiers |= TRANSIENT;
        } else if (mod.equalsIgnoreCase(names[13])) {
            this.modifiers |= VOLATILE;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isPrivate()) {
            buf.append(names[5]);
            buf.append(" ");
        }
        if (this.isProtected()) {
            buf.append(names[6]);
            buf.append(" ");
        }
        if (this.isPublic()) {
            buf.append(names[7]);
            buf.append(" ");
        }
        if (this.isAbstract()) {
            buf.append(names[0]);
            buf.append(" ");
        }
        if (this.isExplicit()) {
            buf.append(names[1]);
            buf.append(" ");
        }
        if (this.isFinal()) {
            buf.append(names[2]);
            buf.append(" ");
        }
        if (this.isInterface()) {
            buf.append(names[3]);
            buf.append(" ");
        }
        if (this.isNative()) {
            buf.append(names[4]);
            buf.append(" ");
        }
        if (this.isStatic()) {
            buf.append(names[8]);
            buf.append(" ");
        }
        if (this.isStrict()) {
            buf.append(names[9]);
            buf.append(" ");
        }
        if (this.isStrictFP()) {
            buf.append(names[10]);
            buf.append(" ");
        }
        if (this.isSynchronized()) {
            buf.append(names[11]);
            buf.append(" ");
        }
        if (this.isTransient()) {
            buf.append(names[12]);
            buf.append(" ");
        }
        if (this.isVolatile()) {
            buf.append(names[13]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public String toStandardOrderString() {
        StringBuffer buf = new StringBuffer();
        if (this.isPrivate()) {
            buf.append(names[5]);
            buf.append(" ");
        }
        if (this.isProtected()) {
            buf.append(names[6]);
            buf.append(" ");
        }
        if (this.isPublic()) {
            buf.append(names[7]);
            buf.append(" ");
        }
        if (this.isAbstract()) {
            buf.append(names[0]);
            buf.append(" ");
        }
        if (this.isExplicit()) {
            buf.append(names[1]);
            buf.append(" ");
        }
        if (this.isInterface()) {
            buf.append(names[3]);
            buf.append(" ");
        }
        if (this.isStatic()) {
            buf.append(names[8]);
            buf.append(" ");
        }
        if (this.isStrict()) {
            buf.append(names[9]);
            buf.append(" ");
        }
        if (this.isFinal()) {
            buf.append(names[2]);
            buf.append(" ");
        }
        if (this.isSynchronized()) {
            buf.append(names[11]);
            buf.append(" ");
        }
        if (this.isTransient()) {
            buf.append(names[12]);
            buf.append(" ");
        }
        if (this.isVolatile()) {
            buf.append(names[13]);
            buf.append(" ");
        }
        if (this.isNative()) {
            buf.append(names[4]);
            buf.append(" ");
        }
        if (this.isStrictFP()) {
            buf.append(names[10]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public void copy(ModifierHolder source) {
        this.modifiers = source.modifiers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModifierHolder) {
            ModifierHolder other = (ModifierHolder)obj;
            return other.modifiers == this.modifiers;
        }
        return false;
    }

    public int hashCode() {
        return this.modifiers;
    }

    protected void setCode(boolean value, int code) {
        this.modifiers = value ? (this.modifiers |= code) : (this.modifiers &= ~code);
    }
}

