/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.PrintData;

public class NamedJavaDocComponent
extends JavaDocComponent {
    private String id = "";

    public void setID(String newID) {
        if (newID != null) {
            this.id = newID;
            this.setLongestLength(this.getType().length() + this.id.length() + 2);
        }
    }

    public String getID() {
        return this.id;
    }

    public void print(PrintData printData) {
        this.setPrinted(true);
        printData.indent();
        if (!printData.isStarsAlignedWithSlash()) {
            printData.space();
        }
        printData.appendComment("*", 1);
        if (printData.isSpaceBeforeAt()) {
            printData.appendComment(" ", 1);
        }
        printData.appendComment(this.getType(), 1);
        int i = 0;
        while (i < printData.getJavadocIndent()) {
            printData.appendComment(" ", 1);
            ++i;
        }
        printData.appendComment(this.getID(), 1);
        if (!printData.isJavadocLinedUp() && this.getID().length() > 0) {
            printData.appendComment(" ", 1);
        } else if (printData.isKeepErroneousJavadocTags() && this.getType().endsWith("error")) {
            printData.appendComment(" ", 1);
        }
        if (printData.isJavadocDescriptionLinedup()) {
            this.LineUpIndent(printData);
        } else {
            this.NoLineUpIndent(printData);
        }
        printData.newline();
    }

    private void LineUpIndent(PrintData printData) {
        if (printData.isJavadocLinedUp()) {
            int extra = this.getLongestLength() - (this.getType().length() + this.getID().length()) - 1;
            int ndx = 0;
            while (ndx < extra) {
                printData.appendComment(" ", 1);
                ++ndx;
            }
            int indent = this.getLongestLength();
            if (printData.isSpaceBeforeAt()) {
                ++indent;
            }
            this.wordwrapDescription(printData, indent);
        } else {
            this.printDescription(printData);
        }
    }

    private void NoLineUpIndent(PrintData printData) {
        if (printData.isJavadocLinedUp()) {
            int extra = this.getLongestLength() - (this.getType().length() + this.getID().length());
            int ndx = 0;
            while (ndx < extra) {
                printData.appendComment(" ", 1);
                ++ndx;
            }
        }
        this.printDescription(printData);
    }
}

