/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.acm.seguin.awt.Question;
import org.acm.seguin.io.InplaceOutputStream;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.PrettyPrintVisitor;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.util.FileSettings;

public class PrettyPrintFile {
    private ParserFactory factory;
    private boolean ask = true;

    public void setAsk(boolean way) {
        this.ask = way;
    }

    public void setParserFactory(ParserFactory factory) {
        this.factory = factory;
    }

    public boolean isApplicable(File inputFile) {
        if (!inputFile.canWrite()) {
            return false;
        }
        boolean result = true;
        if (this.ask) {
            result = Question.isYes("Pretty Printer", "Do you want to pretty print the file\n" + inputFile.getPath() + "?");
        }
        if (result) {
            this.setParserFactory(new FileParserFactory(inputFile));
        }
        return result;
    }

    public ParserFactory getParserFactory() {
        return this.factory;
    }

    public void apply(File inputFile) {
        SimpleNode root = this.factory.getAbstractSyntaxTree(true);
        this.apply(inputFile, root);
    }

    public void apply(File inputFile, SimpleNode root) {
        if (root != null) {
            FileSettings pretty = FileSettings.getRefactoryPrettySettings();
            pretty.setReloadNow(true);
            PrettyPrintVisitor printer = new PrettyPrintVisitor();
            PrintData data = this.getPrintData(inputFile);
            if (root instanceof ASTCompilationUnit) {
                printer.visit((ASTCompilationUnit)root, (Object)data);
            } else {
                printer.visit(root, (Object)data);
            }
            data.close();
        }
    }

    protected OutputStream getOutputStream(File file) {
        OutputStream out = null;
        try {
            out = new InplaceOutputStream(file);
        }
        catch (IOException ioe) {
            out = System.out;
        }
        return out;
    }

    protected PrintData getPrintData(File input) {
        JavadocTags.get().reload();
        return new PrintData(this.getOutputStream(input));
    }
}

