/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.Enumeration;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.Token;
import org.acm.seguin.parser.ast.ASTAdditiveExpression;
import org.acm.seguin.parser.ast.ASTAllocationExpression;
import org.acm.seguin.parser.ast.ASTAndExpression;
import org.acm.seguin.parser.ast.ASTArgumentList;
import org.acm.seguin.parser.ast.ASTArguments;
import org.acm.seguin.parser.ast.ASTArrayDimsAndInits;
import org.acm.seguin.parser.ast.ASTArrayInitializer;
import org.acm.seguin.parser.ast.ASTAssertionStatement;
import org.acm.seguin.parser.ast.ASTAssignmentOperator;
import org.acm.seguin.parser.ast.ASTAttribute;
import org.acm.seguin.parser.ast.ASTBlock;
import org.acm.seguin.parser.ast.ASTBlockStatement;
import org.acm.seguin.parser.ast.ASTBooleanLiteral;
import org.acm.seguin.parser.ast.ASTBreakStatement;
import org.acm.seguin.parser.ast.ASTCastExpression;
import org.acm.seguin.parser.ast.ASTCastLookahead;
import org.acm.seguin.parser.ast.ASTClassBody;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTClassDeclaration;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.ASTConditionalAndExpression;
import org.acm.seguin.parser.ast.ASTConditionalExpression;
import org.acm.seguin.parser.ast.ASTConditionalOrExpression;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTContinueStatement;
import org.acm.seguin.parser.ast.ASTDoStatement;
import org.acm.seguin.parser.ast.ASTEmptyStatement;
import org.acm.seguin.parser.ast.ASTEnumDeclaration;
import org.acm.seguin.parser.ast.ASTEnumElement;
import org.acm.seguin.parser.ast.ASTEqualityExpression;
import org.acm.seguin.parser.ast.ASTExclusiveOrExpression;
import org.acm.seguin.parser.ast.ASTExplicitConstructorInvocation;
import org.acm.seguin.parser.ast.ASTExpression;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTForInit;
import org.acm.seguin.parser.ast.ASTForStatement;
import org.acm.seguin.parser.ast.ASTForUpdate;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTGenericNameList;
import org.acm.seguin.parser.ast.ASTIdentifier;
import org.acm.seguin.parser.ast.ASTIfStatement;
import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTInclusiveOrExpression;
import org.acm.seguin.parser.ast.ASTInitializer;
import org.acm.seguin.parser.ast.ASTInstanceOfExpression;
import org.acm.seguin.parser.ast.ASTInterfaceBody;
import org.acm.seguin.parser.ast.ASTInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceMemberDeclaration;
import org.acm.seguin.parser.ast.ASTLabeledStatement;
import org.acm.seguin.parser.ast.ASTLiteral;
import org.acm.seguin.parser.ast.ASTLocalVariableDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclarationLookahead;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTMultiplicativeExpression;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTNestedClassDeclaration;
import org.acm.seguin.parser.ast.ASTNestedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTNullLiteral;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTPostfixExpression;
import org.acm.seguin.parser.ast.ASTPreDecrementExpression;
import org.acm.seguin.parser.ast.ASTPreIncrementExpression;
import org.acm.seguin.parser.ast.ASTPrimaryExpression;
import org.acm.seguin.parser.ast.ASTPrimaryPrefix;
import org.acm.seguin.parser.ast.ASTPrimarySuffix;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTReferenceType;
import org.acm.seguin.parser.ast.ASTReferenceTypeList;
import org.acm.seguin.parser.ast.ASTReferenceVariance;
import org.acm.seguin.parser.ast.ASTRelationalExpression;
import org.acm.seguin.parser.ast.ASTResultType;
import org.acm.seguin.parser.ast.ASTReturnStatement;
import org.acm.seguin.parser.ast.ASTShiftExpression;
import org.acm.seguin.parser.ast.ASTStatement;
import org.acm.seguin.parser.ast.ASTStatementExpression;
import org.acm.seguin.parser.ast.ASTStatementExpressionList;
import org.acm.seguin.parser.ast.ASTSwitchLabel;
import org.acm.seguin.parser.ast.ASTSwitchStatement;
import org.acm.seguin.parser.ast.ASTSynchronizedStatement;
import org.acm.seguin.parser.ast.ASTThrowStatement;
import org.acm.seguin.parser.ast.ASTTryStatement;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTTypeArguments;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.ASTTypeParameter;
import org.acm.seguin.parser.ast.ASTTypeParameterList;
import org.acm.seguin.parser.ast.ASTTypeParameters;
import org.acm.seguin.parser.ast.ASTUnaryExpression;
import org.acm.seguin.parser.ast.ASTUnaryExpressionNotPlusMinus;
import org.acm.seguin.parser.ast.ASTUnmodifiedClassDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTVariableDeclarator;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.ASTVariableInitializer;
import org.acm.seguin.parser.ast.ASTVariance;
import org.acm.seguin.parser.ast.ASTWhileStatement;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.FieldSize;
import org.acm.seguin.pretty.FieldSizeLookAhead;
import org.acm.seguin.pretty.LocalVariableLookAhead;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.SpecialTokenData;
import org.acm.seguin.pretty.SpecialTokenVisitor;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrettyPrintVisitor
implements JavaParserVisitor {
    SpecialTokenVisitor specialTokenVisitor = new SpecialTokenVisitor();
    private boolean enclosingIfStatement = false;
    private FieldSizeLookAhead fsla = new FieldSizeLookAhead(3);
    private LocalVariableLookAhead lvla = new LocalVariableLookAhead();
    private static final String[] ENUM_MODIFIERS = new String[]{"static", "transient", "volatile", "final", "public", "protected", "private"};
    private static final String[] CLASS_DECLARATION_MODIFIERS = new String[]{"final", "public", "abstract", "strictfp"};
    private static final String[] NESTED_CLASS_MODIFIERS = new String[]{"static", "abstract", "strictfp", "final", "public", "protected", "private"};
    private static final String[] INTERFACE_MODIFIERS = new String[]{"strictfp", "abstract", "public"};
    private static final String[] NESTED_INTERFACE_MODIFIERS = new String[]{"static", "strictfp", "abstract", "final", "public", "protected", "private"};
    private static final String[] FIELD_MODIFIERS = new String[]{"static", "transient", "volatile", "final", "public", "protected", "private"};
    private static final String[] METHOD_MODIFIERS = new String[]{"synchronized", "static", "native", "volatile", "final", "public", "protected", "private"};
    private static final String[] CONSTRUCTOR_MODIFIERS = new String[]{"public", "protected", "private", "id"};

    public Object visit(SimpleNode node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTVariance node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "[.");
        printData.appendText("[");
        printData.appendText(node.getName());
        this.jjtAcceptSpecial(node, printData, "].");
        printData.appendText("]");
        return data;
    }

    public Object visit(ASTTypeParameterList node, Object data) {
        PrintData printData = (PrintData)data;
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTTypeParameter node, Object data) {
        PrintData printData = (PrintData)data;
        printData.appendText(node.getName());
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            if (ndx == 1) {
                this.jjtAcceptSpecial(node, printData, "extends.");
                printData.appendText(" extends ");
            } else if (ndx > 1) {
                this.jjtAcceptSpecial(node, printData, "and.");
                printData.appendText(" & ");
            }
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTTypeParameters node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "<.");
        printData.appendText("<");
        node.childrenAccept(this, data);
        printData.appendText(">");
        this.jjtAcceptSpecial(node, printData, ">.");
        return data;
    }

    public Object visit(ASTTypeArguments node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "<.");
        printData.appendText("<");
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, ">.");
        printData.appendText(">");
        return data;
    }

    public Object visit(ASTReferenceTypeList node, Object data) {
        PrintData printData = (PrintData)data;
        int countChildren = node.jjtGetNumChildren();
        if (countChildren > 0) {
            int ndx = 0;
            while (ndx < countChildren) {
                if (ndx > 0) {
                    this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                    printData.appendText(", ");
                }
                node.jjtGetChild(ndx).jjtAccept(this, data);
                ++ndx;
            }
        }
        return data;
    }

    public Object visit(ASTReferenceType node, Object data) {
        PrintData printData = (PrintData)data;
        int childrenCount = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < childrenCount) {
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTReferenceVariance node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.isBiVariance()) {
            this.jjtAcceptSpecial(node, printData, "star");
            printData.appendText("*");
        }
        int childrenCount = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < childrenCount) {
            if (node.isCoVariance()) {
                this.jjtAcceptSpecial(node, printData, "plus");
                printData.appendText("+");
            } else if (node.isContraVariance()) {
                this.jjtAcceptSpecial(node, printData, "minus");
                printData.appendText("-");
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTGenericNameList node, Object data) {
        PrintData printData = (PrintData)data;
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            Node child = node.jjtGetChild(ndx);
            if (ndx > 0 && child instanceof ASTName) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            child.jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        printData.beginEnum();
        this.jjtAcceptSpecials(node, printData, ENUM_MODIFIERS);
        if (this.isJavadocRequired(node, printData)) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        String modifiers = node.getModifiersString(printData.getModifierOrder());
        printData.appendKeyword(modifiers);
        printData.appendText("enum ");
        Node next = node.jjtGetChild(0);
        next.jjtAccept(this, data);
        printData.appendText(" { ");
        boolean printingElements = true;
        int countChildren = node.jjtGetNumChildren();
        int ndx = 1;
        while (ndx < countChildren) {
            Node child = node.jjtGetChild(ndx);
            if (!(child instanceof ASTEnumElement) && printingElements) {
                this.jjtAcceptSpecial(node, printData, "semicolon");
                printData.appendText(";");
                printingElements = false;
                printData.incrIndent();
                printData.newline();
            }
            if (ndx > 1 && printingElements) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            child.jjtAccept(this, data);
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, "end");
        if (!printingElements) {
            printData.decrIndent();
            printData.indent();
            printData.appendText("}");
        } else {
            printData.appendText(" }");
        }
        printData.newline();
        printData.endEnum();
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        return data;
    }

    public Object visit(ASTEnumElement node, Object data) {
        PrintData printData = (PrintData)data;
        int countChildren = node.jjtGetNumChildren();
        printData.appendText(node.getName());
        int ndx = 1;
        while (ndx < countChildren) {
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTAttribute node, Object data) {
        PrintData printData = (PrintData)data;
        printData.appendText("@");
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        printData.space();
        return data;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        PrintData printData = (PrintData)data;
        node.sort(printData.getTopOrder(node));
        this.loadHeader(node, printData);
        node.childrenAccept(this, data);
        if (!this.loadFooter(printData)) {
            this.jjtAcceptSpecial(node, printData, "EOF");
        }
        printData.flush();
        return data;
    }

    public Object visit(ASTPackageDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "package");
        printData.appendKeyword("package");
        printData.space();
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        int ndx = 0;
        while (ndx <= printData.getLinesAfterPackage()) {
            printData.newline();
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "import", printData.isMaintainNewlinesAroundImports());
        printData.appendKeyword("import");
        if (node.isStaticImport()) {
            this.jjtAcceptSpecial(node, printData, "static");
            printData.appendKeyword(" static");
        }
        printData.space();
        node.childrenAccept(this, data);
        if (node.isImportingPackage()) {
            this.jjtAcceptSpecial(node, printData, "period");
            printData.appendText(".");
            this.jjtAcceptSpecial(node, printData, "star");
            printData.appendText("*");
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
            printData.newline();
        } else {
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
            printData.newline();
        }
        return data;
    }

    public Object visit(ASTTypeDeclaration node, Object data) {
        if (node.hasAnyChildren()) {
            node.childrenAccept(this, data);
        } else {
            PrintData printData = (PrintData)data;
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
            printData.newline();
        }
        return data;
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        int ndx = 0;
        while (ndx < printData.getLinesBeforeClass()) {
            printData.newline();
            ++ndx;
        }
        this.jjtAcceptSpecials(node, printData, CLASS_DECLARATION_MODIFIERS);
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(child.getSpecial("class"), printData));
        if (node.isRequired()) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTUnmodifiedClassDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            node.jjtGetChild(0).jjtAccept(this, data);
            ++child;
        }
        printData.appendKeyword("class");
        printData.space();
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        printData.pushCurrentClassName(node.getName());
        int lastIndex = node.jjtGetNumChildren();
        int ndx = child;
        while (ndx < lastIndex) {
            int indentation;
            Node next = node.jjtGetChild(ndx);
            if (next instanceof ASTTypeParameterList) {
                this.jjtAcceptSpecial(node, printData, "extends");
                printData.space();
                next.jjtAccept(this, data);
            } else if (next instanceof ASTName) {
                this.jjtAcceptSpecial(node, printData, "extends");
                if (printData.isLineBeforeExtends()) {
                    indentation = printData.getExtendsIndentation();
                    printData.incrIndent(indentation);
                    printData.indent();
                    printData.incrIndent(-indentation);
                } else {
                    printData.space();
                }
                printData.appendKeyword("extends");
                printData.space();
                next.jjtAccept(this, data);
            } else if (next instanceof ASTNameList) {
                this.jjtAcceptSpecial(node, printData, "implements");
                if (printData.isLineBeforeImplements()) {
                    indentation = printData.getImplementsIndentation();
                    printData.incrIndent(indentation);
                    printData.indent();
                    printData.incrIndent(-indentation);
                } else {
                    printData.space();
                }
                printData.appendKeyword("implements");
                printData.space();
                next.jjtAccept(this, data);
            } else {
                next.jjtAccept(this, data);
            }
            ++ndx;
        }
        printData.popCurrentClassName();
        return data;
    }

    public Object visit(ASTClassBody node, Object data) {
        return this.visit(node, data, true);
    }

    public Object visit(ASTClassBody node, Object data, boolean newline) {
        PrintData printData = (PrintData)data;
        node.sort(printData.getOrder());
        FieldSizeLookAhead fsla = new FieldSizeLookAhead(printData.getFieldSpaceCode());
        FieldSize size = fsla.run(node);
        size.update(printData.getDynamicFieldSpaces());
        printData.pushFieldSize(size);
        printData.classBrace();
        printData.beginBlock();
        this.jjtAcceptSpecial(node, printData, "begin", false);
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "end");
        printData.classBrace();
        printData.endBlock(newline, true);
        printData.popFieldSize();
        return data;
    }

    public Object visit(ASTNestedClassDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        printData.beginClass();
        this.jjtAcceptSpecials(node, printData, NESTED_CLASS_MODIFIERS);
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(child.getSpecial("class"), printData));
        if (this.isJavadocRequired(node, printData)) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        node.childrenAccept(this, data);
        printData.endClass();
        return data;
    }

    public Object visit(ASTClassBodyDeclaration node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTMethodDeclarationLookahead node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTInterfaceDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        int ndx = 0;
        while (ndx < printData.getLinesBeforeClass()) {
            printData.newline();
            ++ndx;
        }
        this.jjtAcceptSpecials(node, printData, INTERFACE_MODIFIERS);
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(child.getSpecial("interface"), printData));
        if (node.isRequired()) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTNestedInterfaceDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        printData.beginInterface();
        this.jjtAcceptSpecials(node, printData, NESTED_INTERFACE_MODIFIERS);
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(child.getSpecial("interface"), printData));
        if (this.isJavadocRequired(node, printData)) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        node.childrenAccept(this, data);
        printData.endInterface();
        return data;
    }

    public Object visit(ASTUnmodifiedInterfaceDeclaration node, Object data) {
        boolean first = true;
        PrintData printData = (PrintData)data;
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            node.jjtGetChild(0).jjtAccept(this, data);
        }
        printData.appendKeyword("interface");
        printData.space();
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        printData.pushCurrentClassName(node.getName());
        int n = ++child;
        ++child;
        Node next = node.jjtGetChild(n);
        if (next instanceof ASTNameList) {
            this.jjtAcceptSpecial(node, printData, "extends");
            if (printData.isLineBeforeExtends()) {
                int indentation = printData.getExtendsIndentation();
                printData.incrIndent(indentation);
                printData.indent();
                printData.incrIndent(-indentation);
            } else {
                printData.space();
            }
            printData.appendKeyword("extends");
            printData.space();
            next.jjtAccept(this, data);
            next = node.jjtGetChild(child++);
        }
        next.jjtAccept(this, data);
        printData.popCurrentClassName();
        return data;
    }

    public Object visit(ASTInterfaceBody node, Object data) {
        PrintData printData = (PrintData)data;
        FieldSizeLookAhead fsla = new FieldSizeLookAhead(printData.getFieldSpaceCode());
        FieldSize size = fsla.run(node);
        size.update(printData.getDynamicFieldSpaces());
        printData.pushFieldSize(size);
        printData.classBrace();
        printData.beginBlock();
        this.jjtAcceptSpecial(node, printData, "begin", false);
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "end");
        printData.classBrace();
        printData.endBlock();
        printData.popFieldSize();
        return data;
    }

    public Object visit(ASTInterfaceMemberDeclaration node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        Node next;
        PrintData printData = (PrintData)data;
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        ASTType type = (ASTType)node.jjtGetChild(child);
        printData.beginField();
        this.jjtAcceptSpecials(node, printData, FIELD_MODIFIERS);
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(this.getInitialToken(type), printData));
        if (this.isJavadocRequired(node, printData)) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        String modifiers = node.getModifiersString(printData.getModifierOrder());
        printData.appendKeyword(modifiers);
        if (printData.isDynamicFieldSpacing(node.isJavadocPrinted())) {
            FieldSize size = printData.topFieldSize();
            int maxModifier = size.getModifierLength();
            int ndx = modifiers.length();
            while (ndx < maxModifier) {
                printData.space();
                ++ndx;
            }
        }
        if (child == 1) {
            next = node.jjtGetChild(0);
            next.jjtAccept(this, data);
        }
        next = node.jjtGetChild(child);
        next.jjtAccept(this, data);
        if (printData.isDynamicFieldSpacing(node.isJavadocPrinted())) {
            int current = this.fsla.computeTypeLength(node);
            FieldSize size = printData.topFieldSize();
            int maxType = size.getTypeLength();
            int ndx = current;
            while (ndx < maxType) {
                printData.space();
                ++ndx;
            }
        }
        if (printData.getFieldSpaceCode() == 3) {
            printData.setTempEqualsLength(this.fsla.computeEqualsLength(node));
        }
        this.standardFieldIndent(printData);
        next = node.jjtGetChild(child + 1);
        printData.setStoreJavadocPrinted(node.isJavadocPrinted());
        next.jjtAccept(this, data);
        printData.setStoreJavadocPrinted(false);
        int lastIndex = node.jjtGetNumChildren();
        int ndx = child + 2;
        while (ndx < lastIndex) {
            this.jjtAcceptSpecial(node, printData, "comma." + (ndx - (child + 2)));
            printData.appendText(", ");
            next = node.jjtGetChild(ndx);
            next.jjtAccept(this, data);
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        printData.newline();
        printData.endField();
        return data;
    }

    public Object visit(ASTVariableDeclarator node, Object data) {
        int ndx;
        int maxName;
        FieldSize size;
        int current;
        PrintData printData = (PrintData)data;
        Node next = node.jjtGetChild(0);
        next.jjtAccept(this, data);
        if (printData.isDynamicFieldSpacing(printData.isStoreJavadocPrinted()) && node.jjtGetNumChildren() > 1) {
            current = ((ASTVariableDeclaratorId)next).getName().length();
            size = printData.topFieldSize();
            maxName = size.getNameLength();
            ndx = current;
            while (ndx < maxName) {
                printData.space();
                ++ndx;
            }
        }
        if (printData.getFieldSpaceCode() == 3 && node.jjtGetNumChildren() > 1 && !printData.getSkipNameSpacing()) {
            current = printData.getTempEqualsLength();
            size = printData.topFieldSize();
            maxName = size.getEqualsLength();
            ndx = current;
            while (ndx < maxName) {
                printData.space();
                ++ndx;
            }
        }
        printData.setStoreJavadocPrinted(false);
        if (node.jjtGetNumChildren() > 1) {
            this.jjtAcceptSpecial(node, printData, "equals");
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            printData.appendText("=");
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            next = node.jjtGetChild(1);
            next.jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        int last = node.getArrayCount();
        int ndx = 0;
        while (ndx < last) {
            if (node.jjtGetChild(ndx) instanceof ASTVariance) {
                node.jjtGetChild(ndx).jjtAccept(this, data);
            } else {
                this.jjtAcceptSpecial(node, printData, "[." + ndx);
                printData.appendText("[");
                this.jjtAcceptSpecial(node, printData, "]." + ndx);
                printData.appendText("]");
            }
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTVariableInitializer node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTArrayInitializer node, Object data) {
        PrintData printData = (PrintData)data;
        int incrBy = 3;
        if (!printData.isArrayInitializerIndented()) {
            int n = incrBy = printData.getIndent() <= 1 ? 1 : 0;
            if (incrBy == 1) {
                printData.decrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.SINGLE_INDENT) {
                printData.decrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.DOUBLE_INDENT) {
                printData.decrIndent();
                printData.decrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.PARAM_INDENT) {
                printData.decrIndent();
            }
        }
        this.jjtAcceptSpecial(node, printData, "begin");
        printData.appendText("{");
        if (printData.isIndentInInitailzer()) {
            printData.incrIndent();
        }
        int last = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < last) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        if (node.isFinalComma()) {
            this.jjtAcceptSpecial(node, printData, "comma." + (last - 1));
            printData.appendText(",");
        }
        if (printData.isIndentInInitailzer()) {
            printData.decrIndent();
        }
        this.jjtAcceptSpecial(node, printData, "end");
        printData.appendText("}");
        if (!printData.isArrayInitializerIndented()) {
            if (incrBy == 1) {
                printData.incrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.SINGLE_INDENT) {
                printData.incrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.DOUBLE_INDENT) {
                printData.incrIndent();
                printData.incrIndent();
            } else if (printData.getSurpriseReturn() == PrintData.PARAM_INDENT) {
                printData.incrIndent();
            }
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        Node next;
        PrintData printData = (PrintData)data;
        printData.beginMethod();
        this.jjtAcceptSpecials(node, printData, METHOD_MODIFIERS);
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        if (node.jjtGetChild(child) instanceof ASTTypeParameters) {
            ++child;
        }
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(this.getInitialToken((ASTResultType)node.jjtGetChild(child)), printData));
        if (this.isJavadocRequired(node, printData)) {
            node.finish(printData.getCurrentClassName());
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        int i = 0;
        while (i < child) {
            next = node.jjtGetChild(i);
            next.jjtAccept(this, data);
            if (next instanceof ASTTypeParameters) {
                printData.space();
            }
            ++i;
        }
        next = node.jjtGetChild(child++);
        next.jjtAccept(this, data);
        printData.space();
        next = node.jjtGetChild(child++);
        next.jjtAccept(this, data);
        int lastIndex = node.jjtGetNumChildren();
        boolean foundBlock = false;
        int ndx = child;
        while (ndx < lastIndex) {
            next = node.jjtGetChild(ndx);
            if (next instanceof ASTNameList) {
                this.jjtAcceptSpecial(node, printData, "throws");
                printData.space();
                if (printData.isThrowsOnNewline()) {
                    printData.incrIndent();
                    printData.indent();
                    printData.decrIndent();
                }
                printData.appendKeyword("throws");
                printData.space();
                next.jjtAccept(this, data);
            } else if (next instanceof ASTBlock) {
                foundBlock = true;
                if (next.jjtGetNumChildren() == 0 && printData.isEmptyBlockOnSingleLine() && !this.isCommentsPresent((ASTBlock)next)) {
                    printData.appendText(" { }");
                    printData.newline();
                } else {
                    printData.methodBrace();
                    next.jjtAccept(this, data);
                }
            }
            ++ndx;
        }
        if (!foundBlock) {
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
            printData.newline();
        }
        printData.endMethod();
        return data;
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTFormalParameters node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "begin");
        if (printData.isSpaceAfterMethod() && node.hasAnyChildren()) {
            printData.space();
        }
        printData.beginExpression(node.hasAnyChildren());
        printData.enterMethodDecl();
        int lastIndex = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < lastIndex) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            Node next = node.jjtGetChild(ndx);
            next.jjtAccept(this, data);
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, "end");
        printData.endExpression(node.hasAnyChildren());
        printData.exitMethodDecl();
        return data;
    }

    public Object visit(ASTFormalParameter node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.isUsingFinal()) {
            this.jjtAcceptSpecial(node, printData, "final");
            printData.appendKeyword("final");
            printData.space();
        }
        printData.setParamIndent();
        Node next = node.jjtGetChild(0);
        next.jjtAccept(this, data);
        printData.space();
        next = node.jjtGetChild(1);
        next.jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        Node next;
        PrintData printData = (PrintData)data;
        printData.beginMethod();
        this.jjtAcceptSpecials(node, printData, CONSTRUCTOR_MODIFIERS);
        if (node.isRequired()) {
            node.finish();
            node.printJavaDocComponents(printData);
        }
        printData.indent();
        printData.appendKeyword(node.getModifiersString(printData.getModifierOrder()));
        int child = 0;
        if (node.jjtGetChild(0) instanceof ASTAttribute) {
            next = node.jjtGetChild(0);
            next.jjtAccept(this, data);
            ++child;
        }
        if (node.jjtGetChild(child) instanceof ASTTypeParameters) {
            next = node.jjtGetChild(child);
            next.jjtAccept(this, data);
            ++child;
        }
        printData.appendText(node.getName());
        next = node.jjtGetChild(child);
        next.jjtAccept(this, data);
        int lastIndex = node.jjtGetNumChildren();
        if (lastIndex > ++child && (next = node.jjtGetChild(child)) instanceof ASTNameList) {
            this.jjtAcceptSpecial(node, printData, "throws");
            printData.space();
            if (printData.isThrowsOnNewline()) {
                printData.incrIndent();
                printData.indent();
                printData.decrIndent();
            }
            printData.appendKeyword("throws");
            printData.space();
            next.jjtAccept(this, data);
            ++child;
        }
        if (lastIndex == child && printData.isEmptyBlockOnSingleLine()) {
            printData.appendText(" { }");
            printData.newline();
        } else {
            LocalVariableLookAhead lvla = new LocalVariableLookAhead();
            FieldSize size = lvla.run(node);
            size.update(printData.getDynamicFieldSpaces());
            printData.pushFieldSize(size);
            printData.methodBrace();
            printData.beginBlock();
            this.jjtAcceptSpecial(node, printData, "begin", false);
            if (printData.isLineBeforeMultistatementMethodBody() && lastIndex - child > 1 && printData.getMethodBlockStyle() == 0) {
                printData.newline();
            }
            boolean foundBlock = false;
            int ndx = child;
            while (ndx < lastIndex) {
                next = node.jjtGetChild(ndx);
                next.jjtAccept(this, data);
                ++ndx;
            }
            this.jjtAcceptSpecial(node, printData, "end");
            printData.methodBrace();
            printData.endBlock();
        }
        printData.endMethod();
        return data;
    }

    public Object visit(ASTExplicitConstructorInvocation node, Object data) {
        PrintData printData = (PrintData)data;
        int startWith = 0;
        printData.indent();
        if (node.jjtGetChild(0) instanceof ASTPrimaryExpression) {
            node.jjtGetChild(0).jjtAccept(this, data);
            ++startWith;
            this.jjtAcceptSpecial(node, printData, ".");
            printData.appendText(".");
        }
        this.jjtAcceptSpecial(node, printData, "explicit");
        printData.appendText(node.getName());
        int last = node.jjtGetNumChildren();
        int ndx = startWith;
        while (ndx < last) {
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        printData.newline();
        return data;
    }

    public Object visit(ASTInitializer node, Object data) {
        PrintData printData = (PrintData)data;
        printData.indent();
        if (node.isUsingStatic()) {
            this.jjtAcceptSpecial(node, printData, "static");
            printData.appendKeyword("static");
        }
        ASTBlock block = (ASTBlock)node.jjtGetChild(0);
        this.blockProcess(block, printData, true, node.isUsingStatic());
        return data;
    }

    public Object visit(ASTType node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.jjtGetChild(0) != null) {
            node.jjtGetChild(0).jjtAccept(this, data);
        }
        int count = node.getArrayCount();
        int ndx = 0;
        while (ndx < count) {
            if (node.jjtGetChild(ndx + 1) instanceof ASTVariance) {
                node.jjtGetChild(ndx + 1).jjtAccept(this, data);
            } else {
                this.jjtAcceptSpecial(node, printData, "[." + ndx);
                printData.appendText("[");
                this.jjtAcceptSpecial(node, printData, "]." + ndx);
                printData.appendText("]");
            }
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTPrimitiveType node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "primitive");
        printData.appendKeyword(node.getName());
        return data;
    }

    public Object visit(ASTResultType node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.hasAnyChildren()) {
            node.childrenAccept(this, data);
        } else {
            this.jjtAcceptSpecial(node, printData, "primitive");
            printData.appendKeyword("void");
        }
        return data;
    }

    public Object visit(ASTName node, Object data) {
        PrintData printData = (PrintData)data;
        int size = node.getNameSize();
        int ndx = 0;
        while (ndx < size) {
            this.jjtAcceptSpecial(node, printData, "id" + ndx);
            this.jjtAcceptSpecial(node, printData, "period" + ndx);
            ++ndx;
        }
        printData.appendText(node.getName());
        return data;
    }

    public Object visit(ASTNameList node, Object data) {
        PrintData printData = (PrintData)data;
        int countChildren = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < countChildren) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            Node child = node.jjtGetChild(ndx);
            child.jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTExpression node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTAssignmentOperator node, Object data) {
        PrintData printData = (PrintData)data;
        if (printData.isSpaceAroundOperators()) {
            printData.space();
        }
        this.jjtAcceptSpecial(node, printData, "operator");
        printData.appendText(node.getName());
        if (printData.isSpaceAroundOperators()) {
            printData.space();
        }
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        PrintData printData = (PrintData)data;
        int childCount = node.jjtGetNumChildren();
        if (childCount == 1) {
            node.jjtGetChild(0).jjtAccept(this, data);
        } else {
            node.jjtGetChild(0).jjtAccept(this, data);
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            this.jjtAcceptSpecial(node, printData, "?");
            printData.appendText("?");
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            node.jjtGetChild(1).jjtAccept(this, data);
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            this.jjtAcceptSpecial(node, printData, ":");
            printData.appendText(":");
            if (printData.isSpaceAroundOperators()) {
                printData.space();
            }
            node.jjtGetChild(2).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTConditionalOrExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "||", data);
    }

    public Object visit(ASTConditionalAndExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "&&", data);
    }

    public Object visit(ASTInclusiveOrExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "|", data);
    }

    public Object visit(ASTExclusiveOrExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "^", data);
    }

    public Object visit(ASTAndExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "&", data);
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, node.getNames(), data);
    }

    public Object visit(ASTInstanceOfExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, "instanceof", data);
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, node.getNames(), data);
    }

    public Object visit(ASTShiftExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, node.getNames(), data);
    }

    public Object visit(ASTAdditiveExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, node.getNames(), data);
    }

    public Object visit(ASTMultiplicativeExpression node, Object data) {
        return this.binaryExpression((SimpleNode)node, node.getNames(), data);
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        PrintData printData = (PrintData)data;
        Node child = node.jjtGetChild(0);
        if (child instanceof ASTUnaryExpression) {
            this.jjtAcceptSpecial(node, printData, "operator");
            printData.appendText(node.getName());
        }
        child.jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTPreIncrementExpression node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "operator");
        printData.appendText("++");
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTPreDecrementExpression node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "operator");
        printData.appendText("--");
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTUnaryExpressionNotPlusMinus node, Object data) {
        PrintData printData = (PrintData)data;
        Node child = node.jjtGetChild(0);
        if (child instanceof ASTUnaryExpression) {
            this.jjtAcceptSpecial(node, printData, "operator");
            printData.appendText(node.getName());
            if (node.getName().equals("!") && printData.isBangSpace()) {
                printData.space();
            }
        }
        child.jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTCastLookahead node, Object data) {
        PrintData printData = (PrintData)data;
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTPostfixExpression node, Object data) {
        PrintData printData = (PrintData)data;
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "operator");
        printData.appendText(node.getName());
        return data;
    }

    public Object visit(ASTCastExpression node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "begin");
        printData.beginExpression(printData.isCastSpace());
        if (printData.isSpaceInsideCast()) {
            printData.space();
        }
        node.jjtGetChild(0).jjtAccept(this, data);
        if (printData.isSpaceInsideCast()) {
            printData.space();
        }
        this.jjtAcceptSpecial(node, printData, "end");
        printData.endExpression(printData.isCastSpace());
        if (printData.isSpaceAfterCast()) {
            printData.space();
        }
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTPrimaryExpression node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTPrimaryPrefix node, Object data) {
        PrintData printData = (PrintData)data;
        int ndx = 0;
        while (ndx < node.getCount()) {
            this.jjtAcceptSpecial(node, printData, "this." + ndx);
            ++ndx;
        }
        if (node.jjtGetNumChildren() == 0) {
            this.jjtAcceptSpecial(node, printData, "this");
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendText(node.getName());
        } else {
            Node child = node.jjtGetChild(0);
            if (child instanceof ASTLiteral || child instanceof ASTName || child instanceof ASTAllocationExpression) {
                child.jjtAccept(this, data);
            } else if (child instanceof ASTExpression) {
                this.jjtAcceptSpecial(node, printData, "begin");
                if (printData.isSpaceAfterMethod() && node.hasAnyChildren() && printData.isSpaceAroundOperators()) {
                    printData.space();
                }
                printData.beginExpression(node.hasAnyChildren());
                child.jjtAccept(this, data);
                this.jjtAcceptSpecial(node, printData, "end");
                printData.endExpression(node.hasAnyChildren());
            } else if (child instanceof ASTResultType) {
                child.jjtAccept(this, data);
                printData.appendText(".class");
            }
        }
        return data;
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.jjtGetNumChildren() == 0) {
            this.jjtAcceptSpecial(node, printData, "dot");
            printData.appendText(".");
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendText(node.getName());
        } else {
            Node child = node.jjtGetChild(0);
            if (child instanceof ASTArguments) {
                child.jjtAccept(this, data);
            } else if (child instanceof ASTExpression) {
                this.jjtAcceptSpecial(node, printData, "[");
                printData.appendText("[");
                child.jjtAccept(this, data);
                this.jjtAcceptSpecial(node, printData, "]");
                printData.appendText("]");
            } else if (child instanceof ASTAllocationExpression) {
                this.jjtAcceptSpecial(node, printData, "dot");
                printData.appendText(".");
                this.jjtAcceptSpecial(node, printData, "id");
                child.jjtAccept(this, data);
            }
        }
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.hasAnyChildren()) {
            node.childrenAccept(this, data);
        } else {
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendConstant(node.getName());
        }
        return data;
    }

    public Object visit(ASTBooleanLiteral node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendConstant(node.getName());
        return data;
    }

    public Object visit(ASTNullLiteral node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendConstant("null");
        return data;
    }

    public Object visit(ASTArguments node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "begin");
        if (printData.isSpaceAfterMethod() && node.hasAnyChildren()) {
            printData.space();
        }
        printData.beginExpression(node.hasAnyChildren());
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "end");
        printData.endExpression(node.hasAnyChildren());
        return data;
    }

    public Object visit(ASTArgumentList node, Object data) {
        PrintData printData = (PrintData)data;
        int count = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < count) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.jjtGetChild(node.jjtGetNumChildren() - 1) instanceof ASTClassBody) {
            int lastType = printData.getState();
            printData.setState(PrintData.EMPTY);
            printData.incrIndent();
            this.jjtAcceptSpecial(node, printData, "id");
            printData.indent();
            printData.appendKeyword("new");
            printData.space();
            SimpleNode nameNode = (SimpleNode)node.jjtGetChild(0);
            nameNode.jjtAccept(this, data);
            int x = 0;
            if (node.jjtGetChild(1) instanceof ASTTypeArguments) {
                ++x;
                ASTTypeArguments typeArguments = (ASTTypeArguments)node.jjtGetChild(1);
                typeArguments.jjtAccept(this, data);
            }
            SimpleNode arguments = (SimpleNode)node.jjtGetChild(1 + x);
            arguments.jjtAccept(this, data);
            ASTClassBody classBody = (ASTClassBody)node.jjtGetChild(2 + x);
            this.visit(classBody, data, false);
            printData.decrIndent();
            printData.setState(lastType);
        } else {
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendKeyword("new");
            printData.space();
            node.childrenAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTArrayDimsAndInits node, Object data) {
        PrintData printData = (PrintData)data;
        boolean foundInitializer = false;
        int last = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < last) {
            if (node.jjtGetChild(ndx) instanceof ASTExpression) {
                this.jjtAcceptSpecial(node, printData, "[." + ndx);
                printData.appendText("[");
                node.jjtGetChild(ndx).jjtAccept(this, data);
                this.jjtAcceptSpecial(node, printData, "]." + ndx);
                printData.appendText("]");
            } else if (node.jjtGetChild(ndx) instanceof ASTVariance) {
                node.jjtGetChild(ndx).jjtAccept(this, data);
            } else if (node.jjtGetChild(ndx) instanceof ASTArrayInitializer) {
                foundInitializer = true;
            }
            ++ndx;
        }
        int looping = node.getArrayCount();
        if (foundInitializer) {
            ++looping;
        }
        int ndx2 = last;
        while (ndx2 < looping) {
            if (node.jjtGetChild(ndx2) instanceof ASTVariance) {
                node.jjtGetChild(ndx2).jjtAccept(this, data);
            } else {
                this.jjtAcceptSpecial(node, printData, "[." + ndx2);
                printData.appendText("[");
                this.jjtAcceptSpecial(node, printData, "]." + ndx2);
                printData.appendText("]");
            }
            ++ndx2;
        }
        if (foundInitializer) {
            node.jjtGetChild(last - 1).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTStatement node, Object data) {
        PrintData printData = (PrintData)data;
        printData.indent();
        node.childrenAccept(this, data);
        if (node.jjtGetChild(0) instanceof ASTStatementExpression) {
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
            printData.newline();
        }
        return data;
    }

    public Object visit(ASTLabeledStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "id");
        printData.appendText(node.getName());
        this.jjtAcceptSpecial(node, printData, "colon");
        printData.appendText(": ");
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTBlock node, Object data) {
        PrintData printData = (PrintData)data;
        this.blockProcess(node, printData, true);
        return data;
    }

    public Object visit(ASTBlockStatement node, Object data) {
        SimpleNode child;
        PrintData printData = (PrintData)data;
        if (node.hasAnyChildren()) {
            child = (SimpleNode)node.jjtGetChild(0);
            if (child instanceof ASTUnmodifiedClassDeclaration) {
                printData.beginClass();
                if (node.isFinal()) {
                    this.jjtAcceptSpecial(node, printData, "final");
                }
                this.jjtAcceptSpecial(node, printData, "class");
                printData.indent();
                if (node.isFinal()) {
                    printData.appendKeyword("final");
                    printData.space();
                }
            } else if (child instanceof ASTUnmodifiedInterfaceDeclaration) {
                printData.beginClass();
                if (node.isFinal()) {
                    this.jjtAcceptSpecial(node, printData, "final");
                }
                this.jjtAcceptSpecial(node, printData, "interface");
                printData.indent();
                if (node.isFinal()) {
                    printData.appendKeyword("final");
                    printData.space();
                }
            } else if (printData.isInsertSpaceLocalVariables() && child instanceof ASTLocalVariableDeclaration && !this.isLastLocalVariable(node)) {
                printData.newline();
            }
        }
        node.childrenAccept(this, data);
        if (node.hasAnyChildren()) {
            child = (SimpleNode)node.jjtGetChild(0);
            if (child instanceof ASTUnmodifiedClassDeclaration) {
                printData.endClass();
            } else if (child instanceof ASTUnmodifiedInterfaceDeclaration) {
                printData.endClass();
            } else if (printData.isInsertSpaceLocalVariables() && child instanceof ASTLocalVariableDeclaration && !this.isNextLocalVariable(node)) {
                printData.newline();
                printData.newline();
            }
        }
        return data;
    }

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        int last = node.jjtGetNumChildren();
        Node typeNode = node.jjtGetChild(0);
        int ndx = 1;
        while (ndx < last) {
            FieldSize size;
            this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
            if (printData.isVariablesAlignWithBlock()) {
                printData.decrIndent();
                printData.indent();
            } else {
                printData.indent();
            }
            int current = 0;
            if (node.isUsingFinal()) {
                this.jjtAcceptSpecial(node, printData, "final");
                printData.appendKeyword("final");
                printData.space();
                current = 6;
            }
            if (printData.isDynamicFieldSpacing(false)) {
                size = printData.topFieldSize();
                int maxModifier = size.getModifierLength();
                int modifierIndex = current;
                while (modifierIndex < maxModifier) {
                    printData.space();
                    ++modifierIndex;
                }
            }
            typeNode.jjtAccept(this, data);
            printData.space();
            if (printData.isVariablesAlignWithBlock()) {
                printData.incrIndent();
            }
            if (printData.isDynamicFieldSpacing(false)) {
                current = this.lvla.computeTypeLength(node);
                size = printData.topFieldSize();
                int maxType = size.getTypeLength();
                int typeIndex = current;
                while (typeIndex < maxType) {
                    printData.space();
                    ++typeIndex;
                }
            }
            if (printData.getFieldSpaceCode() == 3) {
                printData.setTempEqualsLength(this.lvla.computeEqualsLength(node));
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            printData.appendText(";");
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTEmptyStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        printData.newline();
        return data;
    }

    public Object visit(ASTStatementExpression node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.jjtGetChild(0) instanceof ASTPrimaryExpression) {
            int last = node.jjtGetNumChildren();
            node.jjtGetChild(0).jjtAccept(this, data);
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendText(node.getName());
            int ndx = 1;
            while (ndx < last) {
                node.jjtGetChild(ndx).jjtAccept(this, data);
                ++ndx;
            }
        } else {
            node.childrenAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "switch");
        printData.appendKeyword("switch");
        this.jjtAcceptSpecial(node, printData, "beginExpr");
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.beginExpression(true);
        node.jjtGetChild(0).jjtAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(true);
        printData.beginBlock();
        printData.decrIndent();
        printData.incrCaseIndent();
        this.jjtAcceptSpecial(node, printData, "beginBlock", false);
        int last = node.jjtGetNumChildren();
        int ndx = 1;
        while (ndx < last) {
            Node next = node.jjtGetChild(ndx);
            if (next instanceof ASTBlockStatement) {
                boolean indent = this.shouldIndentSwitchBody(next);
                if (indent) {
                    printData.incrIndent();
                    next.jjtAccept(this, data);
                    printData.decrIndent();
                } else {
                    Node child = next.jjtGetChild(0);
                    Node grandchild = child.jjtGetChild(0);
                    printData.indent();
                    this.blockProcess((ASTBlock)grandchild, printData, true, false);
                }
            } else {
                next.jjtAccept(this, data);
            }
            ++ndx;
        }
        this.jjtAcceptSpecial(node, printData, "endBlock");
        printData.decrCaseIndent();
        printData.incrIndent();
        printData.endBlock();
        return data;
    }

    public Object visit(ASTSwitchLabel node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.hasAnyChildren()) {
            this.jjtAcceptSpecial(node, printData, "id");
            printData.indent();
            printData.appendKeyword("case");
            printData.space();
            node.childrenAccept(this, data);
            this.jjtAcceptSpecial(node, printData, "colon");
            printData.appendText(":");
            printData.newline();
        } else {
            this.jjtAcceptSpecial(node, printData, "id");
            this.jjtAcceptSpecial(node, printData, "colon");
            printData.indent();
            printData.appendKeyword("default");
            printData.appendText(":");
            printData.newline();
        }
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        boolean hasElse;
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "if");
        printData.appendKeyword("if");
        this.jjtAcceptSpecial(node, printData, "beginExpr");
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.beginExpression(true);
        node.jjtGetChild(0).jjtAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(true);
        boolean bl = hasElse = node.jjtGetNumChildren() == 3;
        if (node.jjtGetNumChildren() >= 2) {
            boolean oldEnclosingIfStatement = this.enclosingIfStatement;
            this.enclosingIfStatement = true;
            this.forceBlock(node.jjtGetChild(1), printData, !hasElse && printData.isElseOnNewLine(), printData.isRemoveExcessBlocks() && !this.isIfStatement(node.jjtGetChild(1)));
            this.enclosingIfStatement = oldEnclosingIfStatement;
        }
        if (hasElse) {
            boolean shouldIndent = this.isShouldIndentBeforeElse(printData, node);
            if (shouldIndent) {
                printData.indent();
            } else {
                printData.space();
            }
            this.jjtAcceptSpecial(node, printData, "else", shouldIndent);
            printData.appendKeyword("else");
            ASTStatement child = (ASTStatement)node.jjtGetChild(2);
            Node next = child.jjtGetChild(0);
            if (next instanceof ASTIfStatement) {
                printData.space();
                Token special = ((ASTIfStatement)next).getSpecial("if");
                Token prev = null;
                Token first = null;
                while (special != null) {
                    if (special.kind >= 4 && special.kind <= 6) {
                        special.kind = 1;
                        special.image = " ";
                    } else if (first == null) {
                        prev = first = special;
                    } else {
                        prev.specialToken = special;
                        prev = special;
                    }
                    special = special.specialToken;
                }
                if (first != null) {
                    prev.specialToken = null;
                    special = ((ASTIfStatement)next).getSpecial("if");
                    special.kind = first.kind;
                    special.image = first.image;
                    special.specialToken = first.specialToken;
                } else {
                    ((ASTIfStatement)next).removeSpecial("if");
                }
                next.jjtAccept(this, data);
            } else {
                this.forceBlock(child, printData, true, printData.isRemoveExcessBlocks());
            }
        }
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "while");
        printData.appendKeyword("while");
        this.jjtAcceptSpecial(node, printData, "beginExpr");
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.beginExpression(true);
        node.jjtGetChild(0).jjtAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(true);
        Node next = node.jjtGetChild(1);
        this.forceBlock(next, printData, true, printData.isRemoveExcessBlocks() && this.isIfStatementWithElse(next));
        return data;
    }

    public Object visit(ASTDoStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "do");
        printData.appendKeyword("do");
        this.forceBlock(node.jjtGetChild(0), printData, false, false);
        this.jjtAcceptSpecial(node, printData, "while", false);
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.appendKeyword("while");
        this.jjtAcceptSpecial(node, printData, "beginExpr", false);
        printData.space();
        printData.beginExpression(true);
        node.jjtGetChild(1).jjtAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(true);
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "for");
        printData.appendKeyword("for");
        this.jjtAcceptSpecial(node, printData, "beginExpr");
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.beginExpression(node.hasAnyChildren());
        Node next = node.jjtGetChild(0);
        int index = 1;
        if (next instanceof ASTLocalVariableDeclaration) {
            printData.setSkipNameSpacing(true);
            this.forInit((ASTLocalVariableDeclaration)next, data);
            printData.setSkipNameSpacing(false);
            next = node.jjtGetChild(index);
            ++index;
            this.jjtAcceptSpecial(node, printData, "loopover");
            printData.appendText(" : ");
            if (next instanceof ASTExpression) {
                next.jjtAccept(this, data);
                next = node.jjtGetChild(index);
                ++index;
            }
        } else {
            if (next instanceof ASTForInit) {
                printData.setSkipNameSpacing(true);
                next.jjtAccept(this, data);
                printData.setSkipNameSpacing(false);
                next = node.jjtGetChild(index);
                ++index;
            }
            this.jjtAcceptSpecial(node, printData, "init");
            printData.appendText("; ");
            if (next instanceof ASTExpression) {
                next.jjtAccept(this, data);
                next = node.jjtGetChild(index);
                ++index;
            }
            this.jjtAcceptSpecial(node, printData, "test");
            printData.appendText("; ");
            if (next instanceof ASTForUpdate) {
                next.jjtAccept(this, data);
                next = node.jjtGetChild(index);
                ++index;
            }
        }
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(node.hasAnyChildren());
        this.forceBlock(next, printData, true, printData.isRemoveExcessBlocks() && (!this.enclosingIfStatement || this.isIfStatementWithElse(next)));
        return data;
    }

    public Object visit(ASTForInit node, Object data) {
        PrintData printData = (PrintData)data;
        Node next = node.jjtGetChild(0);
        if (next instanceof ASTLocalVariableDeclaration) {
            this.forInit((ASTLocalVariableDeclaration)next, data);
        } else {
            node.childrenAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTStatementExpressionList node, Object data) {
        PrintData printData = (PrintData)data;
        int last = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < last) {
            if (ndx > 0) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    public Object visit(ASTForUpdate node, Object data) {
        node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTBreakStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "break");
        printData.appendKeyword("break");
        String name = node.getName();
        if (name != null && name.length() != 0) {
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendText(" " + node.getName());
        }
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        return data;
    }

    public Object visit(ASTContinueStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "continue");
        printData.appendKeyword("continue");
        String name = node.getName();
        if (name != null && name.length() != 0) {
            this.jjtAcceptSpecial(node, printData, "id");
            printData.appendText(" " + node.getName());
        }
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        return data;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.hasAnyChildren()) {
            this.jjtAcceptSpecial(node, printData, "return");
            printData.appendKeyword("return");
            printData.space();
            node.childrenAccept(this, data);
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
        } else {
            this.jjtAcceptSpecial(node, printData, "return");
            printData.appendKeyword("return");
            this.jjtAcceptSpecial(node, printData, "semicolon");
            printData.appendText(";");
        }
        return data;
    }

    public Object visit(ASTThrowStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "throw");
        printData.appendKeyword("throw");
        printData.space();
        node.childrenAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        return data;
    }

    public Object visit(ASTSynchronizedStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "synchronized");
        printData.appendKeyword("synchronized");
        this.jjtAcceptSpecial(node, printData, "beginExpr");
        if (printData.isSpaceAfterKeyword()) {
            printData.space();
        }
        printData.beginExpression(true);
        node.jjtGetChild(0).jjtAccept(this, data);
        this.jjtAcceptSpecial(node, printData, "endExpr");
        printData.endExpression(true);
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    public Object visit(ASTTryStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "try");
        printData.appendKeyword("try");
        this.blockProcess((ASTBlock)node.jjtGetChild(0), printData, printData.isCatchOnNewLine());
        int last = node.jjtGetNumChildren();
        boolean paired = false;
        int catchCount = 0;
        int ndx = 1;
        while (ndx < last) {
            Node next = node.jjtGetChild(ndx);
            if (next instanceof ASTFormalParameter) {
                if (printData.isCatchOnNewLine()) {
                    printData.indent();
                } else {
                    printData.space();
                }
                this.jjtAcceptSpecial(node, printData, "catch" + catchCount, printData.isCatchOnNewLine());
                printData.appendKeyword("catch");
                this.jjtAcceptSpecial(node, printData, "beginExpr" + catchCount);
                if (printData.isSpaceAfterKeyword()) {
                    printData.space();
                }
                printData.beginExpression(true);
                next.jjtAccept(this, data);
                this.jjtAcceptSpecial(node, printData, "endExpr" + catchCount);
                printData.endExpression(true);
                paired = true;
                ++catchCount;
            } else {
                if (!paired) {
                    this.jjtAcceptSpecial(node, printData, "finally", printData.isCatchOnNewLine());
                    if (printData.isCatchOnNewLine()) {
                        printData.indent();
                    } else {
                        printData.space();
                    }
                    printData.appendKeyword("finally");
                }
                this.blockProcess((ASTBlock)next, printData, printData.isCatchOnNewLine());
                paired = false;
            }
            ++ndx;
        }
        if (!printData.isCatchOnNewLine()) {
            printData.newline();
        }
        return data;
    }

    public Object visit(ASTAssertionStatement node, Object data) {
        PrintData printData = (PrintData)data;
        this.jjtAcceptSpecial(node, printData, "assert");
        printData.appendKeyword("assert");
        printData.space();
        node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() > 1) {
            printData.space();
            this.jjtAcceptSpecial(node, printData, "colon");
            printData.appendText(":");
            printData.space();
            node.jjtGetChild(1).jjtAccept(this, data);
        }
        this.jjtAcceptSpecial(node, printData, "semicolon");
        printData.appendText(";");
        return data;
    }

    protected Object binaryExpression(SimpleNode node, String name, Object data) {
        PrintData printData = (PrintData)data;
        int childCount = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < childCount) {
            if (ndx > 0) {
                if (printData.isSpaceAroundOperators() || name.equals("instanceof")) {
                    printData.space();
                }
                this.jjtAcceptSpecial(node, printData, "operator." + (ndx - 1));
                printData.appendText(name);
                if (printData.isSpaceAroundOperators() || name.equals("instanceof")) {
                    printData.space();
                }
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    protected Object binaryExpression(SimpleNode node, Enumeration names, Object data) {
        PrintData printData = (PrintData)data;
        int childCount = node.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < childCount) {
            if (ndx > 0) {
                if (printData.isSpaceAroundOperators()) {
                    printData.space();
                }
                this.jjtAcceptSpecial(node, printData, "operator." + (ndx - 1));
                printData.appendText(names.nextElement().toString());
                if (printData.isSpaceAroundOperators()) {
                    printData.space();
                }
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
        return data;
    }

    protected void forInit(ASTLocalVariableDeclaration node, Object data) {
        PrintData printData = (PrintData)data;
        if (node.isUsingFinal()) {
            this.jjtAcceptSpecial(node, printData, "final");
            printData.appendKeyword("final");
            printData.space();
        }
        int last = node.jjtGetNumChildren();
        Node typeNode = node.jjtGetChild(0);
        typeNode.jjtAccept(this, data);
        printData.space();
        int ndx = 1;
        while (ndx < last) {
            if (ndx > 1) {
                this.jjtAcceptSpecial(node, printData, "comma." + (ndx - 1));
                printData.appendText(", ");
            }
            node.jjtGetChild(ndx).jjtAccept(this, data);
            ++ndx;
        }
    }

    protected void forceBlock(Node node, PrintData printData, boolean newline, boolean canRemoveBlock) {
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0) instanceof ASTBlock) {
            ASTBlock child = (ASTBlock)node.jjtGetChild(0);
            LocalVariableLookAhead lvla = new LocalVariableLookAhead();
            FieldSize size = lvla.run(child);
            size.update(printData.getDynamicFieldSpaces());
            printData.pushFieldSize(size);
            if (this.isThisBlockRequired(canRemoveBlock, node)) {
                printData.beginBlock();
            } else {
                printData.incrIndent();
            }
            this.jjtAcceptSpecial(child, printData, "begin", false);
            child.childrenAccept(this, printData);
            this.jjtAcceptSpecial(child, printData, "end");
            if (this.isThisBlockRequired(canRemoveBlock, node)) {
                printData.endBlock(newline, true);
            } else {
                printData.decrIndent();
            }
            printData.popFieldSize();
        } else {
            if (printData.isForcingBlock()) {
                printData.beginBlock();
            } else {
                printData.incrIndent();
            }
            printData.indent();
            ((SimpleNode)node).childrenAccept(this, printData);
            if (node.jjtGetChild(0) instanceof ASTStatementExpression) {
                printData.appendText(";");
                printData.newline();
            }
            if (printData.isForcingBlock()) {
                printData.endBlock(newline, true);
            } else {
                printData.decrIndent();
            }
        }
    }

    private Token getInitialToken(ASTResultType top) {
        if (top.hasAnyChildren()) {
            ASTType type = (ASTType)top.jjtGetChild(0);
            if (type.jjtGetChild(0) instanceof ASTVariance) {
                Token tok = top.getSpecial("primitive");
                top.removeSpecial("primitive");
                return tok;
            }
            if (type.jjtGetChild(0) instanceof ASTPrimitiveType) {
                ASTPrimitiveType primitiveType = (ASTPrimitiveType)type.jjtGetChild(0);
                Token tok = primitiveType.getSpecial("primitive");
                primitiveType.removeSpecial("primitive");
                return tok;
            }
            if (type.jjtGetChild(0) instanceof ASTReferenceType) {
                ASTReferenceType referenceType = (ASTReferenceType)type.jjtGetChild(0);
                if (referenceType.jjtGetChild(0) instanceof ASTName) {
                    ASTName name = (ASTName)referenceType.jjtGetChild(0);
                    Token tok = name.getSpecial("id0");
                    name.removeSpecial("id0");
                    return tok;
                }
                ASTPrimitiveType primitiveType = (ASTPrimitiveType)referenceType.jjtGetChild(0);
                Token tok = primitiveType.getSpecial("primitive");
                primitiveType.removeSpecial("primitive");
                return tok;
            }
            ASTName name = (ASTName)type.jjtGetChild(0);
            Token tok = name.getSpecial("id0");
            name.removeSpecial("id0");
            return tok;
        }
        Token tok = top.getSpecial("primitive");
        top.removeSpecial("primitive");
        return tok;
    }

    private Token getInitialToken(ASTType top) {
        if (top.jjtGetChild(0) instanceof ASTVariance) {
            Token tok = top.getSpecial("primitive");
            top.removeSpecial("primitive");
            return tok;
        }
        if (top.jjtGetChild(0) instanceof ASTPrimitiveType) {
            ASTPrimitiveType primitiveType = (ASTPrimitiveType)top.jjtGetChild(0);
            Token tok = primitiveType.getSpecial("primitive");
            primitiveType.removeSpecial("primitive");
            return tok;
        }
        if (top.jjtGetChild(0) instanceof ASTReferenceType) {
            ASTReferenceType reference = (ASTReferenceType)top.jjtGetChild(0);
            if (reference.jjtGetChild(0) instanceof ASTPrimitiveType) {
                ASTPrimitiveType primitiveType = (ASTPrimitiveType)reference.jjtGetChild(0);
                Token tok = primitiveType.getSpecial("primitive");
                primitiveType.removeSpecial("primitive");
                return tok;
            }
            ASTName name = (ASTName)reference.jjtGetChild(0);
            Token tok = name.getSpecial("id0");
            name.removeSpecial("id0");
            return tok;
        }
        ASTName name = (ASTName)top.jjtGetChild(0);
        Token tok = name.getSpecial("id0");
        name.removeSpecial("id0");
        return tok;
    }

    private boolean isCommentsPresent(ASTBlock node) {
        int type;
        Token tok = node.getSpecial("end");
        if (tok == null) {
            return false;
        }
        Token current = tok;
        Token previous = tok.specialToken;
        while (previous != null) {
            type = current.kind;
            if (type < 5 || type > 7) {
                return true;
            }
            current = previous;
            previous = current.specialToken;
        }
        type = current.kind;
        return type < 5 || type > 7;
    }

    private boolean isIfStatement(Node node) {
        ASTBlock block;
        ASTBlockStatement blockStatement;
        if (node.jjtGetChild(0) instanceof ASTBlock && (blockStatement = (ASTBlockStatement)(block = (ASTBlock)node.jjtGetChild(0)).jjtGetChild(0)).jjtGetChild(0) instanceof ASTStatement) {
            ASTStatement statement = (ASTStatement)blockStatement.jjtGetChild(0);
            return statement.jjtGetChild(0) instanceof ASTIfStatement;
        }
        return false;
    }

    private boolean isIfStatementWithElse(Node node) {
        ASTStatement statement;
        ASTBlock block;
        ASTBlockStatement blockStatement;
        if (node.jjtGetChild(0) instanceof ASTBlock && (blockStatement = (ASTBlockStatement)(block = (ASTBlock)node.jjtGetChild(0)).jjtGetChild(0)).jjtGetChild(0) instanceof ASTStatement && (statement = (ASTStatement)blockStatement.jjtGetChild(0)).jjtGetChild(0) instanceof ASTIfStatement) {
            ASTIfStatement ifstatement = (ASTIfStatement)statement.jjtGetChild(0);
            return ifstatement.jjtGetNumChildren() == 3;
        }
        return true;
    }

    private boolean isInAnonymousClass(Node node) {
        return node.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTAllocationExpression;
    }

    private boolean isInInnerClass(Node node) {
        Node greatGreatGrandparent = node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent();
        boolean topLevelClass = greatGreatGrandparent instanceof ASTClassDeclaration;
        boolean topLevelInterface = greatGreatGrandparent instanceof ASTInterfaceDeclaration;
        return !topLevelClass && !topLevelInterface;
    }

    private boolean isInnerClass(Node node) {
        return node instanceof ASTNestedClassDeclaration || node instanceof ASTNestedInterfaceDeclaration;
    }

    private boolean isJavadocRequired(SimpleNode node, PrintData printData) {
        if (printData.isNestedClassDocumented()) {
            return node.isRequired() && !this.isInAnonymousClass(node);
        }
        return node.isRequired() && !this.isInAnonymousClass(node) && !this.isInInnerClass(node) && !this.isInnerClass(node);
    }

    private boolean isLastLocalVariable(ASTBlockStatement node) {
        Node parent = node.jjtGetParent();
        int last = parent.jjtGetNumChildren();
        return this.isNeighborLV(parent, node, 1, last, -1);
    }

    private boolean isNeighborLV(Node parent, Node node, int first, int last, int direction) {
        int ndx = first;
        while (ndx < last) {
            if (parent.jjtGetChild(ndx) == node) {
                Node next = parent.jjtGetChild(ndx + direction);
                if (next instanceof ASTBlockStatement) {
                    return next.jjtGetChild(0) instanceof ASTLocalVariableDeclaration;
                }
                return true;
            }
            ++ndx;
        }
        return true;
    }

    private boolean isNextLocalVariable(ASTBlockStatement node) {
        Node parent = node.jjtGetParent();
        int last = parent.jjtGetNumChildren() - 1;
        return this.isNeighborLV(parent, node, 0, last, 1);
    }

    private boolean isShouldIndentBeforeElse(PrintData printData, ASTIfStatement node) {
        if (printData.isElseOnNewLine()) {
            return true;
        }
        return !printData.isForcingBlock() && !(node.jjtGetChild(1) instanceof ASTBlock);
    }

    private boolean isThisBlockRequired(boolean canRemoveBlock, Node node) {
        if (!canRemoveBlock) {
            return true;
        }
        return node.jjtGetChild(0).jjtGetNumChildren() != 1;
    }

    private void blockProcess(ASTBlock node, PrintData printData, boolean newline) {
        this.blockProcess(node, printData, newline, true);
    }

    private void blockProcess(ASTBlock node, PrintData printData, boolean newline, boolean space) {
        boolean onSingleLine = node.jjtGetNumChildren() > 0 || !printData.isEmptyBlockOnSingleLine() || node.getSpecial("end") != null || node.getSpecial("begin") != null;
        LocalVariableLookAhead lvla = new LocalVariableLookAhead();
        FieldSize size = lvla.run(node);
        size.update(printData.getDynamicFieldSpaces());
        printData.pushFieldSize(size);
        printData.beginBlock(space, onSingleLine);
        this.jjtAcceptSpecial(node, printData, "begin", false);
        if (printData.isLineBeforeMultistatementMethodBody() && node.jjtGetParent() instanceof ASTMethodDeclaration && node.jjtGetNumChildren() > 1 && printData.getMethodBlockStyle() == 0) {
            printData.newline();
        }
        node.childrenAccept(this, printData);
        this.jjtAcceptSpecial(node, printData, "end");
        if (node.jjtGetParent() instanceof ASTMethodDeclaration) {
            printData.methodBrace();
        }
        printData.endBlock(newline, onSingleLine);
        printData.popFieldSize();
    }

    private boolean loadFooter(PrintData printData) {
        boolean foundSomething = false;
        try {
            FileSettings settings = FileSettings.getRefactoryPrettySettings();
            String temp = settings.getString("footer.1");
            foundSomething = true;
            int ndx = 1;
            while (true) {
                String nextLine = settings.getString("footer." + ndx);
                printData.appendComment(nextLine, 2);
                printData.newline();
                ++ndx;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            return foundSomething;
        }
    }

    private void loadHeader(ASTCompilationUnit node, PrintData printData) {
        if (node == null) {
            return;
        }
        try {
            FileSettings settings = FileSettings.getRefactoryPrettySettings();
            String temp = settings.getString("header.1");
            SimpleNode child = (SimpleNode)node.jjtGetChild(0);
            if (child == null) {
                return;
            }
            if (child instanceof ASTPackageDeclaration) {
                child.removeSpecial("package");
            } else if (child instanceof ASTImportDeclaration) {
                child.removeSpecial("import");
            } else {
                return;
            }
            int ndx = 1;
            while (true) {
                String nextLine = settings.getString("header." + ndx);
                printData.appendComment(nextLine, 2);
                printData.newline();
                ++ndx;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            return;
        }
    }

    private boolean shouldIndentSwitchBody(Node next) {
        Node grandchild;
        Node child = next.jjtGetChild(0);
        return !(child instanceof ASTStatement) || !((grandchild = child.jjtGetChild(0)) instanceof ASTBlock);
    }

    private void standardFieldIndent(PrintData printData) {
        printData.space();
        if (printData.isFieldNameIndented()) {
            int currentLength = printData.getLineLength();
            int desiredLength = printData.getFieldNameIndent();
            int ndx = currentLength;
            while (ndx < desiredLength) {
                printData.space();
                ++ndx;
            }
        }
    }

    private void jjtAcceptSpecials(SimpleNode node, PrintData printData, String[] specials) {
        int i = 0;
        while (i < specials.length) {
            node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(node.getSpecial(specials[i]), printData));
            ++i;
        }
    }

    private void jjtAcceptSpecial(SimpleNode node, PrintData printData, String special) {
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(node.getSpecial(special), printData));
    }

    private void jjtAcceptSpecial(SimpleNode node, PrintData printData, String special, boolean newline) {
        node.jjtAccept(this.specialTokenVisitor, new SpecialTokenData(node.getSpecial(special), printData, newline));
    }
}

