/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.pretty.FieldSize;
import org.acm.seguin.pretty.LineQueue;
import org.acm.seguin.pretty.sort.MultipleOrdering;
import org.acm.seguin.pretty.sort.SameOrdering;
import org.acm.seguin.pretty.sort.TopLevelOrdering;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.Settings;

public class PrintData {
    public int finalLine = -1;
    private int last = EMPTY;
    private int INDENT = 4;
    private char indentChar = (char)32;
    private int codeBlockStyle = 0;
    private int methodBlockStyle = 0;
    private int classBlockStyle = 0;
    private boolean isMethodBrace = false;
    private boolean lineUpParams = true;
    private boolean inParams = false;
    private int lastParamIndent = 0;
    private boolean exprSpace = false;
    private int linesBetween = 2;
    private int javadocMinimum = 40;
    private int javadocMaximum = 80;
    private boolean spaceAfterCast = true;
    private boolean spaceAfterKeyword = true;
    private boolean spaceAfterMethod = false;
    private boolean spaceInsideCast = false;
    private int javadocStars = 2;
    private int originalLine = -1;
    private boolean storeJavadocPrinted = false;
    private boolean skipNameSpacing = false;
    private int cStyleFormatCode = 0;
    private int cStyleIndent = 2;
    private boolean isClassBrace = false;
    private boolean emptyBlockOnSingleLine = false;
    private boolean castSpace = true;
    private boolean documentNestedClasses = true;
    private boolean elseOnNewLine = true;
    private boolean allowSingleLineJavadoc = false;
    private boolean currentIsSingle = false;
    private boolean variablesAlignWithBlock = false;
    private boolean localVariableSpaceInsert = false;
    private int linesAfterPackage = 1;
    private boolean maintainNewlinesAroundImports = true;
    private int linesBeforeClass = 0;
    private boolean indentInitializer = false;
    private boolean bangSpace = false;
    private boolean spaceAroundOps = true;
    private FileSettings bundle;
    private int caseIndent;
    private Vector classNameStack;
    private int dynamicFieldSpace;
    private int fieldNameIndent;
    private int fieldSpaceCode;
    private Vector fieldStack;
    private boolean forceBlock;
    private String[] importSortImportant;
    private int importSortNeighbourhood;
    private int indent = 0;
    private boolean keepAllJavadoc;
    private boolean keepErroneousJavadocTags;
    private LineQueue lineQueue;
    private MultipleOrdering morder;
    private int newlineCount;
    private StringBuffer outputBuffer;
    private boolean reformatComments;
    private boolean removeExcessBlocks;
    private boolean sortTop;
    private int surpriseType;
    private int tempEqualsLength;
    private boolean lineBeforeExtends = false;
    private int extendsIndentation = 1;
    private boolean lineBeforeImplements = this.lineBeforeExtends;
    private int implementsIndentation = this.extendsIndentation;
    private boolean lineBeforeClassBody = false;
    private boolean lineBeforeMultistatementMethodBody = false;
    private boolean lineupJavadocIDs = true;
    private boolean lineupJavadocDescr = false;
    private int javadocIndent = -1;
    private boolean c_ownline = true;
    public static final int BLOCK_STYLE_C = 0;
    public static final int BLOCK_STYLE_PASCAL = 1;
    public static final int BLOCK_STYLE_EMACS = 2;
    public static int EMPTY;
    public static int METHOD;
    public static int FIELD;
    public static int INTERFACE;
    public static int CLASS;
    public static int ENUM;
    public static int SINGLE_INDENT;
    public static int DOUBLE_INDENT;
    public static int PARAM_INDENT;
    public static int NO_INDENT;
    public static final int JAVADOC_COMMENT = 1;
    public static final int C_STYLE_COMMENT = 2;
    public static final int CATEGORY_COMMENT = 3;
    public static final int SINGLE_LINE_COMMENT = 4;
    public static final int DFS_NEVER = 0;
    public static final int DFS_ALWAYS = 1;
    public static final int DFS_NOT_WITH_JAVADOC = 2;
    public static final int DFS_ALIGN_EQUALS = 3;
    public static final int CSC_LEAVE_UNTOUCHED = 1;
    public static final int CSC_ALIGN_STAR = 0;
    public static final int CSC_ALIGN_BLANK = 2;
    public static final int CSC_MAINTAIN_STAR = 3;
    private boolean arrayInitializerIndented = true;
    public static final int ALPHABETICAL_ORDER = 1;
    public static final int STANDARD_ORDER = 2;
    private int modifierOrder = 1;
    private boolean alignStarsWithSlash = false;
    private int taggedJavadocDescription = 6;

    public PrintData() {
        this(System.out);
    }

    public PrintData(OutputStream out) {
        String temp;
        String surpriseReturnString;
        this.lineQueue = this.lineQueueFactory(new PrintWriter(new OutputStreamWriter(out)));
        this.outputBuffer = new StringBuffer();
        this.newlineCount = 0;
        this.bundle = FileSettings.getRefactoryPrettySettings();
        try {
            this.INDENT = this.bundle.getInteger("indent");
            String indentCharacter = this.bundle.getString("indent.char");
            this.indentChar = indentCharacter.equalsIgnoreCase("space") ? (char)32 : (indentCharacter.equalsIgnoreCase("tab") ? (char)9 : indentCharacter.charAt(0));
        }
        catch (MissingSettingsException mre) {
            // empty catch block
        }
        this.codeBlockStyle = this.translateBlockStyle("block.style");
        this.methodBlockStyle = this.translateBlockStyle("method.block.style");
        this.classBlockStyle = this.translateBlockStyle("class.block.style");
        try {
            this.exprSpace = new Boolean(this.bundle.getString("expr.space"));
        }
        catch (MissingSettingsException mre) {
            // empty catch block
        }
        try {
            this.lineUpParams = new Boolean(this.bundle.getString("params.lineup"));
        }
        catch (MissingSettingsException mre) {
            // empty catch block
        }
        try {
            this.linesBetween = Integer.parseInt(this.bundle.getString("lines.between"));
        }
        catch (MissingSettingsException mre) {
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            this.javadocMinimum = this.bundle.getInteger("javadoc.wordwrap.min");
            this.javadocMaximum = this.bundle.getInteger("javadoc.wordwrap.max");
        }
        catch (MissingSettingsException snfe) {
            // empty catch block
        }
        try {
            this.spaceAfterCast = this.bundle.getBoolean("cast.space");
        }
        catch (MissingSettingsException snfe) {
            // empty catch block
        }
        try {
            this.javadocStars = this.bundle.getInteger("javadoc.star");
        }
        catch (MissingSettingsException snfe) {
            // empty catch block
        }
        try {
            this.spaceAfterKeyword = this.bundle.getBoolean("keyword.space");
        }
        catch (MissingSettingsException snfe) {
            // empty catch block
        }
        try {
            String value = this.bundle.getString("variable.spacing");
            this.fieldSpaceCode = value.equalsIgnoreCase("dynamic") ? 1 : (value.equalsIgnoreCase("javadoc.dynamic") ? 2 : (value.equalsIgnoreCase("align.equals") ? 3 : 0));
        }
        catch (MissingSettingsException snfe) {
            this.fieldSpaceCode = 0;
        }
        this.morder = new MultipleOrdering(this.bundle);
        this.classNameStack = new Vector();
        this.fieldStack = new Vector();
        try {
            surpriseReturnString = this.bundle.getString("surprise.return");
        }
        catch (MissingSettingsException mse) {
            System.out.println("Cannot find surprise.return");
            surpriseReturnString = "double";
        }
        this.surpriseType = surpriseReturnString.equalsIgnoreCase("single") ? SINGLE_INDENT : (surpriseReturnString.equalsIgnoreCase("param") ? PARAM_INDENT : (surpriseReturnString.equalsIgnoreCase("none") ? NO_INDENT : DOUBLE_INDENT));
        try {
            this.reformatComments = this.bundle.getBoolean("reformat.comments");
        }
        catch (MissingSettingsException mse) {
            this.reformatComments = true;
        }
        try {
            this.fieldNameIndent = this.bundle.getInteger("field.name.indent");
        }
        catch (MissingSettingsException mse) {
            this.fieldNameIndent = -1;
        }
        try {
            this.keepAllJavadoc = this.bundle.getBoolean("keep.all.javadoc");
        }
        catch (MissingSettingsException mse) {
            this.keepAllJavadoc = false;
        }
        try {
            this.forceBlock = this.bundle.getBoolean("force.block");
        }
        catch (MissingSettingsException mse) {
            this.forceBlock = true;
        }
        try {
            this.dynamicFieldSpace = this.bundle.getInteger("dynamic.variable.spacing");
        }
        catch (MissingSettingsException mse) {
            this.dynamicFieldSpace = 1;
        }
        try {
            temp = this.bundle.getString("c.style.format");
            this.cStyleFormatCode = temp.equalsIgnoreCase("leave") ? 1 : (temp.equalsIgnoreCase("maintain.space.star") ? 3 : (temp.equalsIgnoreCase("align.blank") ? 2 : 0));
        }
        catch (MissingSettingsException mse) {
            this.cStyleFormatCode = 0;
        }
        try {
            this.cStyleIndent = this.bundle.getInteger("c.style.indent");
        }
        catch (MissingSettingsException mse) {
            this.cStyleIndent = 2;
        }
        try {
            this.emptyBlockOnSingleLine = this.bundle.getBoolean("empty.block.single.line");
        }
        catch (MissingSettingsException mse) {
            this.emptyBlockOnSingleLine = false;
        }
        try {
            this.castSpace = !this.bundle.getBoolean("cast.force.nospace");
        }
        catch (MissingSettingsException mse) {
            this.castSpace = true;
        }
        try {
            this.documentNestedClasses = this.bundle.getBoolean("document.nested.classes");
        }
        catch (MissingSettingsException mse) {
            this.documentNestedClasses = true;
        }
        try {
            this.allowSingleLineJavadoc = this.bundle.getBoolean("allow.singleline.javadoc");
        }
        catch (MissingSettingsException mse) {
            this.allowSingleLineJavadoc = false;
        }
        try {
            this.variablesAlignWithBlock = this.bundle.getBoolean("variable.align.with.block");
        }
        catch (MissingSettingsException mse) {
            this.variablesAlignWithBlock = false;
        }
        try {
            this.elseOnNewLine = this.bundle.getBoolean("else.start.line");
        }
        catch (MissingSettingsException mse) {
            this.elseOnNewLine = true;
        }
        try {
            this.caseIndent = this.bundle.getInteger("case.indent");
        }
        catch (MissingSettingsException mse) {
            this.caseIndent = this.INDENT;
        }
        try {
            this.sortTop = this.bundle.getBoolean("sort.top");
        }
        catch (MissingSettingsException mse) {
            this.sortTop = false;
        }
        try {
            String data = this.bundle.getString("import.sort.important");
            StringTokenizer st = new StringTokenizer(data, ",");
            Vector<String> list = new Vector<String>();
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                if (!value.endsWith(".")) {
                    value = value + ".";
                }
                list.add(value);
            }
            this.importSortImportant = list.toArray(new String[list.size()]);
        }
        catch (MissingSettingsException mse) {
            this.importSortImportant = new String[0];
        }
        try {
            this.importSortNeighbourhood = this.bundle.getInteger("import.sort.neighbourhood");
        }
        catch (MissingSettingsException mse) {
            this.importSortNeighbourhood = 0;
        }
        try {
            this.localVariableSpaceInsert = this.bundle.getBoolean("insert.space.around.local.variables");
        }
        catch (MissingSettingsException mse) {
            this.localVariableSpaceInsert = false;
        }
        try {
            this.removeExcessBlocks = this.bundle.getBoolean("remove.excess.blocks");
        }
        catch (MissingSettingsException mse) {
            this.removeExcessBlocks = false;
        }
        try {
            this.linesAfterPackage = this.bundle.getInteger("lines.after.package");
        }
        catch (MissingSettingsException mse) {
            this.linesAfterPackage = 0;
        }
        try {
            this.maintainNewlinesAroundImports = this.bundle.getBoolean("maintain.newlines.around.imports");
        }
        catch (MissingSettingsException mse) {
            this.maintainNewlinesAroundImports = true;
        }
        try {
            this.linesBeforeClass = this.bundle.getInteger("lines.before.class");
        }
        catch (MissingSettingsException mse) {
            this.linesBeforeClass = 0;
        }
        try {
            this.lineBeforeExtends = this.bundle.getBoolean("line.before.extends");
        }
        catch (MissingSettingsException mse) {
            this.lineBeforeExtends = false;
        }
        try {
            this.extendsIndentation = this.bundle.getInteger("extends.indent");
        }
        catch (MissingSettingsException mse) {
            this.extendsIndentation = 1;
        }
        try {
            this.lineBeforeImplements = this.bundle.getBoolean("line.before.implements");
        }
        catch (MissingSettingsException mse) {
            this.lineBeforeImplements = this.lineBeforeExtends;
        }
        try {
            this.lineBeforeMultistatementMethodBody = this.bundle.getBoolean("line.before.multistatement.method.body");
        }
        catch (MissingSettingsException mse) {
            this.lineBeforeMultistatementMethodBody = false;
        }
        try {
            this.implementsIndentation = this.bundle.getInteger("implements.indent");
        }
        catch (MissingSettingsException mse) {
            this.implementsIndentation = this.extendsIndentation;
        }
        try {
            this.indentInitializer = this.bundle.getBoolean("indent.in.initializer");
        }
        catch (MissingSettingsException mse) {
            this.indentInitializer = false;
        }
        try {
            this.arrayInitializerIndented = this.bundle.getBoolean("indent.braces.initializer");
        }
        catch (MissingSettingsException mse) {
            this.arrayInitializerIndented = true;
        }
        try {
            this.lineBeforeClassBody = this.bundle.getBoolean("line.before.class.body");
        }
        catch (MissingSettingsException mse) {
            this.lineBeforeClassBody = false;
        }
        try {
            this.bangSpace = this.bundle.getBoolean("bang.space");
        }
        catch (MissingSettingsException mse) {
            this.bangSpace = false;
        }
        try {
            this.keepErroneousJavadocTags = this.bundle.getBoolean("keep.erroneous.tags");
        }
        catch (MissingSettingsException mse) {
            this.keepErroneousJavadocTags = false;
        }
        try {
            this.spaceAfterMethod = this.bundle.getBoolean("method.space");
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        try {
            this.spaceInsideCast = this.bundle.getBoolean("cast.inside.space");
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        try {
            this.spaceAroundOps = this.bundle.getBoolean("space.around.ops");
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        try {
            temp = this.bundle.getString("modifier.order");
            temp = temp.toLowerCase();
            this.modifierOrder = temp.startsWith("alpha") ? 1 : 2;
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        try {
            this.alignStarsWithSlash = this.bundle.getBoolean("align.stars.with.slash");
        }
        catch (MissingSettingsException mse) {
            this.alignStarsWithSlash = false;
        }
        try {
            this.lineupJavadocIDs = this.bundle.getBoolean("javadoc.id.lineup");
        }
        catch (MissingSettingsException mse) {
            this.lineupJavadocIDs = true;
        }
        try {
            this.lineupJavadocDescr = this.bundle.getBoolean("javadoc.descr.lineup");
        }
        catch (MissingSettingsException mse) {
            this.lineupJavadocDescr = false;
        }
        try {
            this.taggedJavadocDescription = this.bundle.getInteger("javadoc.tag.indent");
        }
        catch (MissingSettingsException mse) {
            this.taggedJavadocDescription = 6;
        }
        try {
            this.c_ownline = this.bundle.getBoolean("cstyle.comment.ownline");
        }
        catch (MissingSettingsException mse) {
            this.c_ownline = true;
        }
        this.fieldStack = new Vector();
    }

    public void setAbsoluteCommentSpacing(int value) {
        this.lineQueue.setAbsoluteCommentSpacing(value);
    }

    public void setBangSpace(boolean value) {
        this.bangSpace = value;
    }

    public void setCStyleFormatCode(int value) {
        this.cStyleFormatCode = value;
    }

    public void setCStyleIndent(int value) {
        this.cStyleIndent = value;
    }

    public void setCaseIndent(int value) {
        this.caseIndent = value;
    }

    public void setCastSpace(boolean value) {
        this.castSpace = value;
    }

    public void setClassBlockStyle(int value) {
        this.classBlockStyle = value;
    }

    public void setCodeBlockStyle(int value) {
        this.codeBlockStyle = value;
    }

    public void setCurrentIsSingle(boolean value) {
        this.currentIsSingle = value;
    }

    public void setDocumentNestedClasses(boolean value) {
        this.documentNestedClasses = value;
    }

    public void setDynamicFieldSpaces(int value) {
        this.dynamicFieldSpace = value;
    }

    public void setDynamicFieldSpacing(int value) {
        this.fieldSpaceCode = value;
    }

    public void setElseOnNewLine(boolean value) {
        this.elseOnNewLine = value;
    }

    public void setEmptyBlockOnSingleLine(boolean value) {
        this.emptyBlockOnSingleLine = value;
    }

    public void setExpressionSpace(boolean value) {
        this.exprSpace = value;
    }

    public void setFinalLine(int value) {
        this.finalLine = value;
    }

    public void setForceBlock(boolean value) {
        this.forceBlock = value;
    }

    public void setImportSortImportant(String[] newImportSortImportant) {
        this.importSortImportant = newImportSortImportant;
    }

    public void setImportSortNeighbourhood(int newImportSortNeighbourhood) {
        this.importSortNeighbourhood = newImportSortNeighbourhood;
    }

    public void setIncrementalCommentSpacing(int value) {
        this.lineQueue.setIncrementalCommentSpacing(value);
    }

    public void setIndentInInitializer(boolean value) {
        this.indentInitializer = value;
    }

    public void setInsertSpaceLocalVariables(boolean value) {
        this.localVariableSpaceInsert = value;
    }

    public void setKeepErroneousJavadocTags(boolean value) {
        this.keepErroneousJavadocTags = value;
    }

    public void setLinesAfterPackage(int value) {
        this.linesAfterPackage = value;
    }

    public void setLinesBeforeClass(int value) {
        this.linesBeforeClass = value;
    }

    public void setMaintainNewlinesAroundImports(boolean value) {
        this.maintainNewlinesAroundImports = value;
    }

    public void setMethodBlockStyle(int value) {
        this.methodBlockStyle = value;
    }

    public void setMultipleOrdering(MultipleOrdering value) {
        if (value != null) {
            this.morder = value;
        }
    }

    public void setOriginalLine(int value) {
        this.originalLine = value;
    }

    public void setOutput(PrintWriter newOutput) {
        if (newOutput != null) {
            this.lineQueue = this.lineQueueFactory(newOutput);
        }
    }

    public void setOwnline(boolean value) {
        this.lineQueue.setOwnline(value);
    }

    public void setOwnlineCode(boolean value) {
        this.lineQueue.setOwnlineCode(value);
    }

    public void setParamIndent() {
        if (this.inParams && this.lastParamIndent == 0) {
            this.lastParamIndent = this.getLineLength();
        }
    }

    public void setReformatComments(boolean value) {
        this.reformatComments = value;
    }

    public void setRemoveExcessBlocks(boolean value) {
        this.removeExcessBlocks = value;
    }

    public void setSharedIncr(boolean value) {
        this.lineQueue.setSharedIncremental(value);
    }

    public void setSingleLineJavadoc(boolean value) {
        this.allowSingleLineJavadoc = value;
    }

    public void setSortTop(boolean value) {
        this.sortTop = value;
    }

    public void setSpaceAfterMethod(boolean way) {
        this.spaceAfterMethod = way;
    }

    public void setSpaceAfterKeyword(boolean way) {
        this.spaceAfterKeyword = way;
    }

    public void setSpaceAroundOperators(boolean way) {
        this.spaceAroundOps = way;
    }

    public void setSpaceInsideCast(boolean way) {
        this.spaceInsideCast = way;
    }

    public void setState(int newState) {
        this.last = newState;
    }

    public void setVariablesAlignWithBlock(boolean value) {
        this.variablesAlignWithBlock = value;
    }

    public int getCStyleFormatCode() {
        return this.cStyleFormatCode;
    }

    public int getCStyleIndent() {
        return this.cStyleIndent;
    }

    public boolean getCStyleOwnline() {
        return this.c_ownline;
    }

    public void setCStyleOwnline(boolean ownline) {
        this.c_ownline = ownline;
    }

    public String getCurrentClassName() {
        return (String)this.classNameStack.elementAt(this.classNameStack.size() - 1);
    }

    public int getDynamicFieldSpaces() {
        return this.dynamicFieldSpace;
    }

    public int getFieldNameIndent() {
        return this.fieldNameIndent;
    }

    public int getFieldSpaceCode() {
        return this.fieldSpaceCode;
    }

    public int getFinalLine() {
        return this.finalLine;
    }

    public String[] getImportSortImportant() {
        return this.importSortImportant;
    }

    public int getImportSortNeighbourhood() {
        return this.importSortNeighbourhood;
    }

    public String getIndentString() {
        StringBuffer buffer = new StringBuffer();
        int ndx = 0;
        while (ndx < this.indent) {
            buffer.append(this.indentChar);
            ++ndx;
        }
        return buffer.toString();
    }

    public int getJavadocIndent() {
        if (this.javadocIndent >= 0) {
            return this.javadocIndent;
        }
        try {
            this.javadocIndent = this.bundle.getInteger("javadoc.indent");
            return this.javadocIndent;
        }
        catch (MissingSettingsException mre) {
            this.javadocIndent = 2;
            return this.javadocIndent;
        }
    }

    public void setJavadocIndent(int indent) {
        this.javadocIndent = indent;
    }

    public int getJavadocStarCount() {
        return this.javadocStars;
    }

    public int getJavadocWordWrapMaximum() {
        return this.javadocMaximum;
    }

    public void setJavadocWordWrapMaximum(int wrap) {
        this.javadocMaximum = wrap;
    }

    public int getJavadocWordWrapMinimum() {
        return this.javadocMinimum;
    }

    public void setJavadocWordWrapMinimum(int wrap) {
        this.javadocMinimum = wrap;
    }

    public int getLineLength() {
        return this.outputBuffer.length();
    }

    public int getLinesAfterPackage() {
        return this.linesAfterPackage;
    }

    public int getLinesBeforeClass() {
        return this.linesBeforeClass;
    }

    public MultipleOrdering getOrder() {
        return this.morder;
    }

    public int getOriginalLine() {
        return this.originalLine;
    }

    public int getParamIndent() {
        if (this.inParams) {
            return this.lastParamIndent;
        }
        return 0;
    }

    public Settings getSettings() {
        return this.bundle;
    }

    public int getState() {
        return this.last;
    }

    public int getSurpriseReturn() {
        return this.surpriseType;
    }

    public Comparator getTopOrder(ASTCompilationUnit node) {
        try {
            if (this.sortTop) {
                return new TopLevelOrdering(node, this);
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return new SameOrdering();
    }

    public boolean isAllJavadocKept() {
        return this.keepAllJavadoc;
    }

    public boolean isAllowSingleLineJavadoc() {
        return this.allowSingleLineJavadoc;
    }

    public boolean isBangSpace() {
        return this.bangSpace;
    }

    public boolean isBufferEmpty() {
        return this.outputBuffer.toString().trim().length() == 0;
    }

    public boolean isCastSpace() {
        return this.castSpace;
    }

    public boolean isCatchOnNewLine() {
        try {
            return this.bundle.getBoolean("catch.start.line");
        }
        catch (MissingSettingsException mse) {
            return true;
        }
    }

    public boolean isCurrentSingle() {
        return this.currentIsSingle;
    }

    public boolean isDynamicFieldSpacing(boolean javadocPrinted) {
        if (this.skipNameSpacing) {
            return false;
        }
        return !javadocPrinted && this.fieldSpaceCode == 2 || this.fieldSpaceCode == 1;
    }

    public boolean isElseOnNewLine() {
        return this.elseOnNewLine;
    }

    public boolean isEmptyBlockOnSingleLine() {
        return this.emptyBlockOnSingleLine;
    }

    public boolean isFieldNameIndented() {
        return this.fieldNameIndent > 0;
    }

    public boolean isForcingBlock() {
        return this.forceBlock;
    }

    public boolean isIndentInInitailzer() {
        return this.indentInitializer;
    }

    public boolean isInsertSpaceLocalVariables() {
        return this.localVariableSpaceInsert;
    }

    public boolean isJavadocLinedUp() {
        return this.lineupJavadocIDs;
    }

    public boolean isKeepErroneousJavadocTags() {
        return this.keepErroneousJavadocTags;
    }

    public boolean isLineIndented() {
        return this.isBufferEmpty() && (this.outputBuffer.toString().length() > 0 || this.indent == 0);
    }

    public boolean isMaintainNewlinesAroundImports() {
        return this.maintainNewlinesAroundImports;
    }

    public boolean isNestedClassDocumented() {
        return this.documentNestedClasses;
    }

    public boolean isReformatComments() {
        return this.reformatComments;
    }

    public boolean isRemoveExcessBlocks() {
        return this.removeExcessBlocks;
    }

    public boolean isSpaceAfterCast() {
        return this.spaceAfterCast;
    }

    public boolean isSpaceAfterKeyword() {
        return this.spaceAfterKeyword;
    }

    public boolean isSpaceAfterMethod() {
        return this.spaceAfterMethod;
    }

    public boolean isSpaceAroundOperators() {
        return this.spaceAroundOps;
    }

    public boolean isSpaceBeforeAt() {
        try {
            return this.bundle.getBoolean("space.before.javadoc");
        }
        catch (MissingSettingsException mre) {
            return false;
        }
    }

    public boolean isSpaceInsideCast() {
        return this.spaceInsideCast;
    }

    public boolean isThrowsOnNewline() {
        try {
            return this.bundle.getBoolean("throws.newline");
        }
        catch (MissingSettingsException mse) {
            return false;
        }
    }

    public boolean isVariablesAlignWithBlock() {
        return this.variablesAlignWithBlock;
    }

    public void appendComment(String string, int type) {
        if (type == 3) {
            this.lineQueue.appendCategoryComment(string, this.outputBuffer.toString());
            ++this.newlineCount;
        } else if (type == 4) {
            this.lineQueue.appendSingleLineComment(string, this.outputBuffer.toString());
            --this.newlineCount;
        } else {
            this.append(string);
        }
    }

    public void appendConstant(String string) {
        this.outputBuffer.append(string);
    }

    public void appendKeyword(String string) {
        this.append(string);
    }

    public void appendText(String string) {
        this.append(string);
    }

    public void backspace() {
        this.outputBuffer.setLength(this.outputBuffer.length() - 1);
    }

    public void beginBlock() {
        this.beginBlock(true, true);
    }

    public void beginBlock(boolean space) {
        this.beginBlock(space, true);
    }

    public void beginBlock(boolean space, boolean newlineAfter) {
        int currentStyle = this.getCurrentBlockStyle();
        if (currentStyle == 0) {
            if (space) {
                this.space();
            }
            this.append("{");
        } else {
            if (currentStyle == 2) {
                this.incrIndent();
            }
            this.indent();
            this.append("{");
        }
        this.isMethodBrace = false;
        this.isClassBrace = false;
        if (newlineAfter) {
            this.newline();
        }
        this.incrIndent();
    }

    public void beginClass() {
        if (this.last != EMPTY) {
            int ndx = 0;
            while (ndx < this.linesBetween) {
                this.newline();
                ++ndx;
            }
        }
        this.last = EMPTY;
    }

    public void beginExpression(boolean notEmpty) {
        if (!notEmpty || !this.exprSpace) {
            this.append("(");
        } else {
            this.append("( ");
        }
    }

    public void beginEnum() {
        if (this.last != EMPTY && this.last != ENUM) {
            int ndx = 0;
            while (ndx < this.linesBetween) {
                this.newline();
                ++ndx;
            }
        }
    }

    public void beginField() {
        if (this.last != EMPTY && this.last != FIELD) {
            int ndx = 0;
            while (ndx < this.linesBetween) {
                this.newline();
                ++ndx;
            }
        }
    }

    public void beginInterface() {
        if (this.last != EMPTY) {
            int ndx = 0;
            while (ndx < this.linesBetween) {
                this.newline();
                ++ndx;
            }
        }
        this.last = EMPTY;
    }

    public void beginMethod() {
        if (this.last != EMPTY) {
            int ndx = 0;
            while (ndx < this.linesBetween) {
                this.newline();
                ++ndx;
            }
        }
    }

    public void classBrace() {
        this.isClassBrace = true;
    }

    public void close() {
        this.flush();
        this.lineQueue.getOutput().close();
    }

    public boolean consumeNewline() {
        this.lineQueue.flushFirstLine();
        if (!this.isBufferEmpty()) {
            this.newlineCount = 0;
        }
        if (this.newlineCount > 0) {
            --this.newlineCount;
            return true;
        }
        this.newline();
        this.lineQueue.flush();
        return false;
    }

    public void decrCaseIndent() {
        this.incrIndent(-this.caseIndent);
    }

    public void decrIndent() {
        this.incrIndent(-this.INDENT);
    }

    public void endBlock(boolean newline, boolean newlineBefore) {
        this.decrIndent();
        if (newlineBefore || this.outputBuffer.length() == 0) {
            this.indent();
        }
        if (this.getCurrentBlockStyle() == 2) {
            this.decrIndent();
        }
        this.append("}");
        if (newline) {
            this.newline();
        }
        this.isMethodBrace = false;
        this.isClassBrace = false;
    }

    public void endBlock() {
        this.endBlock(true, true);
    }

    public void endClass() {
        this.last = CLASS;
    }

    public void endExpression(boolean notEmpty) {
        if (!notEmpty || !this.exprSpace) {
            this.append(")");
        } else {
            this.append(" )");
        }
    }

    public void endEnum() {
        this.last = ENUM;
    }

    public void endField() {
        this.last = FIELD;
    }

    public void endInterface() {
        this.last = INTERFACE;
    }

    public void endMethod() {
        this.last = METHOD;
    }

    public void enterMethodDecl() {
        this.inParams = true;
        this.lastParamIndent = 0;
    }

    public void exitMethodDecl() {
        this.inParams = false;
        this.lastParamIndent = 0;
    }

    public void flush() {
        this.lineQueue.flush();
    }

    public void incrCaseIndent() {
        this.incrIndent(this.caseIndent);
    }

    public void incrIndent() {
        this.incrIndent(this.INDENT);
    }

    public void indent() {
        if (!this.isBufferEmpty()) {
            this.newline();
        }
        this.outputBuffer.setLength(0);
        this.append(this.getIndentString());
    }

    public void indentParam() {
        if (this.surpriseType == PARAM_INDENT && this.lastParamIndent > 0) {
            this.indent();
            int ndx = 0;
            while (ndx < this.lastParamIndent - this.indent) {
                this.append(" ");
                ++ndx;
            }
        } else {
            this.incrIndent();
            this.indent();
            this.decrIndent();
        }
    }

    public void methodBrace() {
        this.isMethodBrace = true;
    }

    public void newline() {
        String save = "";
        if (this.isBufferEmpty()) {
            this.outputBuffer.setLength(0);
            this.lineQueue.println("");
            ++this.newlineCount;
        } else {
            save = this.outputBuffer.toString();
            this.lineQueue.println(this.outputBuffer.toString());
            this.outputBuffer.setLength(0);
            this.newlineCount = 1;
        }
    }

    public void popCurrentClassName() {
        this.classNameStack.removeElementAt(this.classNameStack.size() - 1);
    }

    public void popFieldSize() {
        this.fieldStack.removeElementAt(this.fieldStack.size() - 1);
    }

    public void pushCurrentClassName(String name) {
        this.classNameStack.addElement(name);
    }

    public void pushFieldSize(FieldSize size) {
        this.fieldStack.addElement(size);
    }

    public void reset() {
        this.outputBuffer.setLength(0);
    }

    public void saveCurrentLine() {
        this.setFinalLine(this.lineQueue.getCurrentLine());
    }

    public void space() {
        this.append(" ");
    }

    public FieldSize topFieldSize() {
        return (FieldSize)this.fieldStack.elementAt(this.fieldStack.size() - 1);
    }

    protected void incrIndent(int incr) {
        this.indent += incr;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public int getIndent() {
        return this.indent;
    }

    protected LineQueue lineQueueFactory(PrintWriter output) {
        return new LineQueue(output);
    }

    void setAllJavadocKept(boolean value) {
        this.keepAllJavadoc = value;
    }

    void setSkipNameSpacing(boolean value) {
        this.skipNameSpacing = value;
    }

    void setStoreJavadocPrinted(boolean value) {
        this.storeJavadocPrinted = value;
    }

    void setTempEqualsLength(int value) {
        this.tempEqualsLength = value;
    }

    boolean getSkipNameSpacing() {
        return this.skipNameSpacing;
    }

    int getTempEqualsLength() {
        return this.tempEqualsLength;
    }

    boolean isStoreJavadocPrinted() {
        return this.storeJavadocPrinted;
    }

    private int getCurrentBlockStyle() {
        if (this.isClassBrace) {
            return this.classBlockStyle;
        }
        if (this.isMethodBrace) {
            return this.methodBlockStyle;
        }
        return this.codeBlockStyle;
    }

    public int getMethodBlockStyle() {
        return this.methodBlockStyle;
    }

    private void append(String string) {
        this.outputBuffer.append(string);
    }

    private int translateBlockStyle(String key) {
        try {
            String code = this.bundle.getString(key);
            if (code.equalsIgnoreCase("PASCAL")) {
                return 1;
            }
            if (code.equalsIgnoreCase("EMACS")) {
                return 2;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return 0;
    }

    public void setLineBeforeClassBody(boolean value) {
        this.lineBeforeClassBody = value;
    }

    public boolean isLineBeforeClassBody() {
        return this.lineBeforeClassBody;
    }

    public void setLineBeforeExtends(boolean value) {
        this.lineBeforeExtends = value;
    }

    public boolean isLineBeforeExtends() {
        return this.lineBeforeExtends;
    }

    public void setExtendsIndentation(int value) {
        this.extendsIndentation = value;
    }

    public int getExtendsIndentation() {
        return this.extendsIndentation;
    }

    public void setLineBeforeImplements(boolean value) {
        this.lineBeforeImplements = value;
    }

    public boolean isLineBeforeImplements() {
        return this.lineBeforeImplements;
    }

    public void setLineBeforeMultistatementMethodBody(boolean value) {
        this.lineBeforeMultistatementMethodBody = value;
    }

    public boolean isLineBeforeMultistatementMethodBody() {
        return this.lineBeforeMultistatementMethodBody;
    }

    public void setImplementsIndentation(int value) {
        this.implementsIndentation = value;
    }

    public int getImplementsIndentation() {
        return this.implementsIndentation;
    }

    public void setArrayInitializerIndented(boolean way) {
        this.arrayInitializerIndented = way;
    }

    public boolean isArrayInitializerIndented() {
        return this.arrayInitializerIndented;
    }

    public void setModifierOrder(int value) {
        this.modifierOrder = value;
    }

    public int getModifierOrder() {
        return this.modifierOrder;
    }

    public void setAlignStarsWithSlash(boolean value) {
        this.alignStarsWithSlash = value;
    }

    public boolean isStarsAlignedWithSlash() {
        return this.alignStarsWithSlash;
    }

    public void setLineupJavadocIDs(boolean way) {
        this.lineupJavadocIDs = way;
    }

    public void setLineupJavadocDescr(boolean way) {
        this.lineupJavadocDescr = way;
    }

    public boolean isJavadocDescriptionLinedup() {
        return this.lineupJavadocDescr;
    }

    public int getTaggedJavadocDescription() {
        return this.taggedJavadocDescription;
    }

    public void setTaggedJavadocDescription(int value) {
        this.taggedJavadocDescription = value;
    }

    public StringBuffer getBuffer() {
        return this.outputBuffer;
    }

    static {
        BLOCK_STYLE_C = 0;
        BLOCK_STYLE_PASCAL = 1;
        BLOCK_STYLE_EMACS = 2;
        EMPTY = 0;
        METHOD = 1;
        FIELD = 2;
        INTERFACE = 3;
        CLASS = 3;
        ENUM = 3;
        SINGLE_INDENT = 1;
        DOUBLE_INDENT = 2;
        PARAM_INDENT = 3;
        NO_INDENT = 4;
        JAVADOC_COMMENT = 1;
        C_STYLE_COMMENT = 2;
        CATEGORY_COMMENT = 3;
        SINGLE_LINE_COMMENT = 4;
        DFS_NEVER = 0;
        DFS_ALWAYS = 1;
        DFS_NOT_WITH_JAVADOC = 2;
        DFS_ALIGN_EQUALS = 3;
        CSC_LEAVE_UNTOUCHED = 1;
        CSC_ALIGN_STAR = 0;
        CSC_ALIGN_BLANK = 2;
        CSC_MAINTAIN_STAR = 3;
        ALPHABETICAL_ORDER = 1;
        STANDARD_ORDER = 2;
    }
}

