/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.Token;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.NamedJavaDocComponent;
import org.acm.seguin.pretty.PrintSpecial;
import org.acm.seguin.pretty.SpecialTokenData;
import org.acm.seguin.pretty.XDocletJavaDocComponent;

public class PrintSpecialJavadocComment
extends PrintSpecial {
    public boolean isAcceptable(SpecialTokenData spec) {
        return spec.getTokenType() == 12;
    }

    public boolean process(Node node, SpecialTokenData spec) {
        JavaDocable docable = null;
        if (node instanceof JavaDocable) {
            docable = (JavaDocable)((Object)node);
        } else if (spec.getPrintData().isAllJavadocKept()) {
            docable = new JavaDocableImpl();
        } else {
            return false;
        }
        JavaDocComponent jdc = new JavaDocComponent();
        StringBuffer description = new StringBuffer();
        JavadocTokenizer tok = new JavadocTokenizer(spec.getTokenImage());
        while (tok.hasNext()) {
            Token next = tok.next();
            if (next.image == null || next.image.length() == 0) continue;
            if (this.isJavadocTag(next)) {
                this.storeJDCinNode(docable, jdc, description);
                jdc = this.createJavaDocComponent(next.image, tok, description);
                continue;
            }
            description.append(next.image);
        }
        if (jdc != null) {
            this.storeJDCinNode(docable, jdc, description);
        }
        if (spec.isLastJavadocComment()) {
            docable.finish();
        }
        docable.printJavaDocComponents(spec.getPrintData());
        return true;
    }

    private boolean isJavadocTag(Token next) {
        if (next.kind != 2) {
            return false;
        }
        String image = next.image;
        if (image.charAt(0) != '@') {
            return false;
        }
        int imageLength = image.length();
        if (image.charAt(imageLength - 1) == '@') {
            return false;
        }
        int ndx = 1;
        while (ndx < imageLength) {
            char c = image.charAt(ndx);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '-') {
                return false;
            }
            ++ndx;
        }
        return true;
    }

    private JavaDocComponent createJavaDocComponent(String current, JavadocTokenizer parts, StringBuffer descr) {
        JavaDocComponent jdc2;
        if (current.equals("@param") || current.equals("@exception") || current.equals("@throws")) {
            NamedJavaDocComponent jdc2 = new NamedJavaDocComponent();
            jdc2.setType(current);
            while (parts.hasNext()) {
                Token next = parts.next();
                if (next.kind != 2) continue;
                jdc2.setID(next.image);
                return jdc2;
            }
            return null;
        }
        if (current.indexOf(46) >= 0) {
            jdc2 = new XDocletJavaDocComponent();
            jdc2.setType(current);
        } else {
            jdc2 = new NamedJavaDocComponent();
            jdc2.setType(current);
        }
        return jdc2;
    }

    private void storeJDCinNode(JavaDocable node, JavaDocComponent jdc, StringBuffer descr) {
        if (jdc == null) {
            return;
        }
        jdc.setDescription(descr.toString().trim());
        node.addJavaDocComponent(jdc);
        descr.setLength(0);
    }
}

