/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.StringTokenizer;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.Token;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.PrintSpecial;
import org.acm.seguin.pretty.SpecialTokenData;
import org.acm.seguin.pretty.SpecialTokenVisitor;

public class PrintSpecialMultiLineComment
extends PrintSpecial {
    public boolean isAcceptable(SpecialTokenData spec) {
        return spec.getTokenType() == 13;
    }

    public boolean process(Node node, SpecialTokenData spec) {
        PrintData printData = spec.getPrintData();
        String image = spec.getTokenImage();
        int formatCode = printData.getCStyleFormatCode();
        if (formatCode == 1) {
            this.transcribe(printData, image);
        } else {
            this.cleanFormat(printData, image, formatCode, spec.isLast());
        }
        return true;
    }

    private void cleanFormat(PrintData printData, String image, int formatCode, boolean last) {
        if (formatCode != 3 && !printData.isLineIndented()) {
            printData.indent();
        }
        if (formatCode == 3) {
            if (!printData.isBufferEmpty()) {
                printData.space();
            } else if (!printData.isLineIndented()) {
                printData.indent();
            }
        }
        printData.appendComment("/*", 2);
        if (formatCode != 3) {
            this.startNewline(printData, true, formatCode);
        }
        JavadocTokenizer tok = new JavadocTokenizer(image);
        tok.next();
        boolean lastWasNewline = false;
        boolean first = true;
        while (tok.hasNext()) {
            Token token = tok.next();
            if (first && (formatCode == 0 || formatCode == 2)) {
                while (token.kind != 2) {
                    if (!tok.hasNext()) break;
                    token = tok.next();
                }
                first = false;
            }
            if (lastWasNewline && token.kind == 0 && formatCode != 3) {
                token = tok.next();
            }
            if (token.kind == 1) {
                this.startNewline(printData, tok.hasNext(), formatCode);
                lastWasNewline = true;
                continue;
            }
            printData.appendComment(token.image, 2);
            lastWasNewline = false;
        }
        if (lastWasNewline) {
            String rest = "/";
            if (formatCode == 2) {
                rest = "*/";
            }
            printData.appendComment(rest, 2);
        } else {
            if (formatCode != 3 && !printData.isLineIndented()) {
                printData.indent();
            }
            if (!printData.isStarsAlignedWithSlash()) {
                printData.space();
            }
            printData.appendComment("*/", 2);
        }
        if ((formatCode == 0 || formatCode == 2) && last) {
            printData.newline();
            SpecialTokenVisitor.surpriseIndent(printData);
        }
    }

    private void startNewline(PrintData printData, boolean more, int formatCode) {
        printData.indent();
        if (formatCode == 2) {
            printData.appendComment("  ", 2);
        } else {
            if (!printData.isStarsAlignedWithSlash()) {
                printData.space();
            }
            printData.appendComment("*", 2);
        }
        if (formatCode != 3 && more) {
            int ndx = 0;
            while (ndx < printData.getCStyleIndent()) {
                printData.appendComment(" ", 2);
                ++ndx;
            }
        }
    }

    private void transcribe(PrintData printData, String image) {
        StringTokenizer tok = new StringTokenizer(image, "\n\r");
        if (!printData.isBufferEmpty()) {
            printData.space();
        } else if (!printData.isLineIndented()) {
            printData.indent();
        }
        while (tok.hasMoreTokens()) {
            printData.appendComment(tok.nextToken(), 2);
            if (!tok.hasMoreTokens()) continue;
            printData.newline();
        }
    }
}

