/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;
import org.acm.seguin.pretty.PrintData;

public class SpecialTokenData {
    private PrintData data;
    private Token special;
    private boolean lastReturnExpected;
    private boolean acceptNewlines;
    private boolean setAcceptingNewlines;
    private boolean reformatComments;

    public SpecialTokenData(Token token, PrintData printData) {
        this(token, printData, true);
    }

    public SpecialTokenData(Token token, PrintData printData, boolean accept) {
        this.data = printData;
        this.special = this.beginning(token);
        this.lastReturnExpected = true;
        this.acceptNewlines = accept;
        this.setAcceptingNewlines = false;
        this.reformatComments = printData.isReformatComments();
    }

    public void setReturnExpected(boolean way) {
        if (!this.setAcceptingNewlines) {
            this.lastReturnExpected = way;
            this.setAcceptingNewlines = true;
        }
    }

    public boolean isLast() {
        return this.special == null || this.special.next == null || "".equals(this.special.next);
    }

    public boolean isLastJavadocComment() {
        boolean last = true;
        Token s = this.special.next;
        while (s != null) {
            if (s.image != null && s.image.startsWith("/**")) {
                last = false;
            }
            s = s.next;
        }
        return last;
    }

    public void convertFirstCStyleCommentToSingleLine() {
        if (this.special != null && this.special.kind == 13 && this.special.image.indexOf(10) < 0) {
            this.special.kind = 11;
        }
    }

    public boolean isFirst() {
        return this.special == null || this.special.specialToken == null;
    }

    public PrintData getPrintData() {
        return this.data;
    }

    public Token getSpecialToken() {
        return this.special;
    }

    public int getTokenType() {
        if (this.special == null) {
            return -1;
        }
        return this.special.kind;
    }

    public String getTokenImage() {
        if (this.special == null) {
            return "";
        }
        return this.special.image;
    }

    public boolean isReturnExpected() {
        return this.lastReturnExpected;
    }

    public boolean isAcceptingReturns() {
        return this.acceptNewlines;
    }

    public boolean isReformattingComments() {
        return this.reformatComments;
    }

    public Token beginning(Token tok) {
        if (tok == null) {
            return null;
        }
        Token current = tok;
        Token previous = tok.specialToken;
        while (previous != null) {
            current = previous;
            previous = current.specialToken;
        }
        return current;
    }

    public void next() {
        if (this.special != null) {
            this.special = this.special.next;
        }
    }
}

