/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;

public class XDocletTokenizer {
    private StringBuffer buffer;
    private int index;
    private int last;
    private String value;
    public static final int SPACE = 0;
    public static final int NEWLINE = 1;
    public static final int WORD = 2;

    public XDocletTokenizer(String init) {
        this.value = init;
        this.index = 0;
        this.buffer = new StringBuffer();
        this.last = this.value.length();
    }

    public boolean hasNext() {
        return this.index < this.last;
    }

    public Token next() {
        Token result = new Token();
        if (this.index == this.last) {
            result.kind = 0;
            result.image = " ";
            return result;
        }
        this.buffer.setLength(0);
        if (this.index == 0 && this.value.charAt(this.index) == '*' || this.index == 0 && this.value.charAt(this.index) == '/' || this.value.charAt(this.index) == '\r' || this.value.charAt(this.index) == '\n') {
            if (this.value.charAt(this.index) == '/') {
                ++this.index;
            }
            this.loadNewline();
            result.kind = 1;
            result.image = this.buffer.toString();
        } else if (Character.isWhitespace(this.value.charAt(this.index))) {
            this.loadSpace();
            result.kind = 0;
            result.image = this.buffer.toString();
        } else {
            this.loadWord();
            result.kind = 2;
            result.image = this.checkEnd(this.buffer.toString());
        }
        return result;
    }

    private String checkEnd(String value) {
        if (value.endsWith("*/")) {
            return value.substring(0, value.length() - 2);
        }
        return value;
    }

    private void loadNewline() {
        while (this.index < this.last && Character.isWhitespace(this.value.charAt(this.index))) {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
        while (this.index < this.last && this.value.charAt(this.index) == '*') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
        if (this.index < this.last && this.value.charAt(this.index - 1) == '*' && this.value.charAt(this.index) == '/') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
    }

    private void loadSpace() {
        while (this.index < this.last && Character.isWhitespace(this.value.charAt(this.index)) && this.value.charAt(this.index) != '\n' && this.value.charAt(this.index) != '\r') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
    }

    private void loadWord() {
        int start = this.index;
        boolean withinQuotes = false;
        while (this.index != this.last) {
            char c = this.value.charAt(this.index);
            if (!withinQuotes && c == '=') {
                if (this.index == start) {
                    this.buffer.append(c);
                    ++this.index;
                }
                return;
            }
            if (!withinQuotes && Character.isWhitespace(c)) {
                return;
            }
            if (c == '\"') {
                withinQuotes = !withinQuotes;
            }
            this.buffer.append(c);
            ++this.index;
        }
        return;
    }

    public static boolean hasContent(String value) {
        char ch;
        if (value == null) {
            return false;
        }
        int valueLength = value.length();
        if (valueLength == 0) {
            return false;
        }
        int start = 0;
        if (value.charAt(0) == '/') {
            ++start;
        }
        int last = valueLength - 1;
        int ndx = start;
        while (ndx < last) {
            ch = value.charAt(ndx);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return true;
            }
            ++ndx;
        }
        ch = value.charAt(last);
        return !Character.isWhitespace(ch) && ch != '*' && ch != '/';
    }

    static {
        SPACE = 0;
        NEWLINE = 1;
        WORD = 2;
    }
}

