/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.ai;

import java.text.MessageFormat;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTAttribute;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTReferenceType;
import org.acm.seguin.parser.ast.ASTResultType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTTypeParameters;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.ASTVariance;
import org.acm.seguin.pretty.DescriptionPadder;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.ai.ParseVariableName;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class MethodAnalyzer {
    private ASTMethodDeclaration node;
    private JavaDocableImpl jdi;
    private ParseVariableName pvn;
    private JavadocTags jt;

    public MethodAnalyzer(ASTMethodDeclaration node, JavaDocableImpl jdi) {
        this.node = node;
        this.jdi = jdi;
        this.pvn = new ParseVariableName();
        this.jt = JavadocTags.get();
    }

    public void finish(String className) {
        FileSettings bundle = FileSettings.getRefactoryPrettySettings();
        this.requireDescription(bundle, className);
        String methodTags = "return,param,exception,throws";
        try {
            methodTags = bundle.getString("method.tags");
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
        if (methodTags.indexOf("return") >= 0) {
            this.finishReturn(bundle);
        }
        if (methodTags.indexOf("param") >= 0) {
            this.finishParameters(bundle);
        }
        this.sortParameters();
        if (methodTags.indexOf("exception") >= 0 || methodTags.indexOf("throws") >= 0 || methodTags.indexOf(this.jt.getExceptionTag()) >= 0) {
            this.finishExceptions(bundle);
        }
    }

    private boolean isSetter() {
        String name = this.getName();
        return name.length() > 3 && name.startsWith("set") && Character.isUpperCase(name.charAt(3));
    }

    private boolean isGetter() {
        String name = this.getName();
        return name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3)) || name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2));
    }

    private boolean isAdder() {
        String name = this.getName();
        return name.length() > 3 && name.startsWith("add") && Character.isUpperCase(name.charAt(3));
    }

    private boolean isRunMethod() {
        String name = this.getName();
        return name.equals("run");
    }

    private boolean isMainMethod() {
        String name = this.getName();
        if (!name.equals("main") || !this.node.isStatic()) {
            return false;
        }
        if (this.node.jjtGetChild(0) instanceof ASTTypeParameters) {
            return false;
        }
        if (this.node.jjtGetChild(0) instanceof ASTAttribute) {
            return false;
        }
        ASTResultType result = (ASTResultType)this.node.jjtGetChild(0);
        if (result.hasAnyChildren()) {
            return false;
        }
        ASTMethodDeclarator decl = (ASTMethodDeclarator)this.node.jjtGetChild(1);
        ASTFormalParameters params = (ASTFormalParameters)decl.jjtGetChild(0);
        int childCount = params.jjtGetNumChildren();
        if (childCount != 1) {
            return false;
        }
        ASTFormalParameter nextParam = (ASTFormalParameter)params.jjtGetChild(0);
        ASTType type = (ASTType)nextParam.jjtGetChild(0);
        Node child = type.jjtGetChild(0);
        if (child instanceof ASTReferenceType) {
            ASTName nameNode;
            ASTReferenceType reference = (ASTReferenceType)child;
            childCount = reference.jjtGetNumChildren();
            if (childCount != 2) {
                return false;
            }
            if (reference.jjtGetChild(0) instanceof ASTName && ((nameNode = (ASTName)reference.jjtGetChild(0)).getName().equals("String") || nameNode.getName().equals("java.lang.String")) && reference.jjtGetChild(1) instanceof ASTVariance) {
                return true;
            }
        }
        return false;
    }

    private boolean isJUnitSetupMethod() {
        String name = this.getName();
        return name.equals("setUp");
    }

    private boolean isJUnitTestMethod() {
        String name = this.getName();
        return name.startsWith("test");
    }

    private boolean isJUnitTeardownMethod() {
        String name = this.getName();
        return name.equals("tearDown");
    }

    private boolean isJUnitSuiteMethod() {
        String name = this.getName();
        return name.equals("suite");
    }

    private String getName() {
        int child = 0;
        if (this.node.jjtGetChild(0) instanceof ASTAttribute) {
            child = 1;
        }
        if (this.node.jjtGetChild(child) instanceof ASTTypeParameters) {
            ASTMethodDeclarator decl = (ASTMethodDeclarator)this.node.jjtGetChild(child + 2);
            return decl.getName();
        }
        ASTMethodDeclarator decl = (ASTMethodDeclarator)this.node.jjtGetChild(child + 1);
        return decl.getName();
    }

    private String getAttributeName() {
        String name = this.getName();
        if (!(this.isGetter() || this.isSetter() || this.isAdder())) {
            return "";
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name.substring(3);
    }

    private String getParameterDescription(FileSettings bundle, String param) {
        String pattern = "";
        pattern = this.isSetter() ? bundle.getString("setter.param.descr") : (this.isAdder() ? bundle.getString("adder.param.descr") : (this.isMainMethod() ? bundle.getString("main.param.descr") : this.jt.getParamDescr()));
        return this.createDescription(pattern, this.getAttributeName(), param);
    }

    private String getReturnDescription(FileSettings bundle) {
        String pattern = "";
        pattern = this.isJUnitSuiteMethod() ? bundle.getString("junit.suite.return.descr") : (this.isGetter() ? bundle.getString("getter.return.descr") : this.jt.getReturnDescr());
        return this.createDescription(pattern, this.getAttributeName(), "");
    }

    private void finishReturn(FileSettings bundle) {
        ASTResultType result;
        int child = 0;
        if (this.node.jjtGetChild(0) instanceof ASTAttribute) {
            ++child;
        }
        if (this.node.jjtGetChild(child) instanceof ASTTypeParameters) {
            ++child;
        }
        if ((result = (ASTResultType)this.node.jjtGetChild(child)).hasAnyChildren() && !this.jdi.contains("@return")) {
            this.jdi.require("@return", this.getReturnDescription(bundle));
        }
    }

    private void finishParameters(FileSettings bundle) {
        int child = 0;
        if (this.node.jjtGetChild(0) instanceof ASTAttribute) {
            // empty if block
        }
        int n = ++child;
        ++child;
        if (this.node.jjtGetChild(n) instanceof ASTTypeParameters) {
            ++child;
        }
        ASTMethodDeclarator decl = (ASTMethodDeclarator)this.node.jjtGetChild(child);
        ASTFormalParameters params = (ASTFormalParameters)decl.jjtGetChild(0);
        int childCount = params.jjtGetNumChildren();
        int ndx = 0;
        while (ndx < childCount) {
            ASTFormalParameter nextParam = (ASTFormalParameter)params.jjtGetChild(ndx);
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)nextParam.jjtGetChild(1);
            if (!this.jdi.contains("@param", id.getName())) {
                this.jdi.require("@param", id.getName(), this.getParameterDescription(bundle, id.getName()));
            }
            ++ndx;
        }
    }

    private void sortParameters() {
        int child = 0;
        if (this.node.jjtGetChild(0) instanceof ASTAttribute) {
            child = 1;
        }
        if (this.node.jjtGetChild(child++) instanceof ASTTypeParameters) {
            ++child;
        }
        ASTMethodDeclarator decl = (ASTMethodDeclarator)this.node.jjtGetChild(child);
        ASTFormalParameters params = (ASTFormalParameters)decl.jjtGetChild(0);
        int childCount = params.jjtGetNumChildren();
        String[] methodParams = new String[childCount];
        int ndx = 0;
        while (ndx < childCount) {
            ASTFormalParameter nextParam = (ASTFormalParameter)params.jjtGetChild(ndx);
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)nextParam.jjtGetChild(1);
            methodParams[ndx] = id.getName();
            ++ndx;
        }
        this.jdi.sort("@param", methodParams);
    }

    private void finishExceptions(FileSettings bundle) {
        if (this.node.jjtGetNumChildren() > 2 && this.node.jjtGetChild(2) instanceof ASTNameList) {
            String exceptionTagName = this.jt.getExceptionTag();
            ASTNameList exceptions = (ASTNameList)this.node.jjtGetChild(2);
            int childCount = exceptions.jjtGetNumChildren();
            int ndx = 0;
            while (ndx < childCount) {
                ASTName name = (ASTName)exceptions.jjtGetChild(ndx);
                if (!(this.jdi.contains("@exception", name.getName()) || this.jdi.contains("@throws", name.getName()) || this.jdi.contains(exceptionTagName, name.getName()))) {
                    this.jdi.require(exceptionTagName, name.getName(), this.jt.getExceptionDescr());
                }
                ++ndx;
            }
        }
    }

    private String createDescription(String pattern, String attribute, String className) {
        Object[] nameArray = new Object[]{attribute, className, this.node.isStatic() ? "class" : "object", this.lowerCaseFirstLetter(attribute), this.pvn.parse(attribute)};
        String msg = MessageFormat.format(pattern, nameArray);
        return msg;
    }

    private void requireDescription(FileSettings bundle, String className) {
        String pattern = "";
        pattern = this.isJUnitSetupMethod() ? bundle.getString("junit.setUp.descr") : (this.isJUnitTestMethod() ? bundle.getString("junit.test.descr") : (this.isJUnitTeardownMethod() ? bundle.getString("junit.tearDown.descr") : (this.isJUnitSuiteMethod() ? bundle.getString("junit.suite.descr") : (this.isGetter() ? bundle.getString("getter.descr") : (this.isSetter() ? bundle.getString("setter.descr") : (this.isRunMethod() ? bundle.getString("run.descr") : (this.isMainMethod() ? bundle.getString("main.descr") : (this.isAdder() ? bundle.getString("adder.descr") : bundle.getString("method.descr")))))))));
        String message = this.createDescription(pattern, this.getAttributeName(), className);
        message = DescriptionPadder.padBuffer(message, bundle);
        this.jdi.require("", message);
    }

    private String lowerCaseFirstLetter(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        if (value.length() == 1) {
            return value.toLowerCase();
        }
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }
}

