/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.ai;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class RequiredTags {
    Object[] arguments = new Object[3];
    private static RequiredTags tags = null;

    private RequiredTags() {
        this.arguments[0] = System.getProperty("user.name");
        this.arguments[1] = DateFormat.getDateInstance(1).format(new Date());
    }

    public void addTags(FileSettings bundle, String key, String name, JavaDocableImpl jdi) {
        String tags = bundle.getString(key + ".tags");
        StringTokenizer tok = new StringTokenizer(tags, ", \t\n");
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            this.add(bundle, next, name, jdi);
        }
    }

    private void add(FileSettings bundle, String tag, String name, JavaDocableImpl jdi) {
        if (!(tag.equalsIgnoreCase("param") || tag.equalsIgnoreCase("return") || tag.equalsIgnoreCase("exception") || tag.equalsIgnoreCase("throws") || jdi.contains(tag))) {
            this.addNormalTag(bundle, tag, name, jdi);
        }
    }

    private void addNormalTag(FileSettings bundle, String tag, String name, JavaDocableImpl jdi) {
        try {
            String format = bundle.getString(tag + ".descr");
            this.arguments[2] = name;
            String value = MessageFormat.format(format, this.arguments);
            if (value == null || value.length() == 0) {
                value = "empty";
            }
            jdi.require("@" + tag, value);
        }
        catch (MissingSettingsException mse) {
            // empty catch block
        }
    }

    public static RequiredTags getTagger() {
        if (tags == null) {
            tags = new RequiredTags();
        }
        return tags;
    }
}

