/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTEnumDeclaration;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceMemberDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTNestedClassDeclaration;
import org.acm.seguin.parser.ast.ASTNestedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTTypeParameters;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.sort.Ordering;

class BeanTogetherOrder
extends Ordering {
    BeanTogetherOrder() {
    }

    public int compare(Object one, Object two) {
        int prefixCodeTwo;
        String propertyTwo;
        String nameOne = this.isBean(one);
        String nameTwo = this.isBean(two);
        if (nameOne == null && nameTwo == null) {
            return 0;
        }
        if (nameOne == null) {
            return -1;
        }
        if (nameTwo == null) {
            return 1;
        }
        String propertyOne = this.getPropertyName(nameOne);
        int compare = propertyOne.compareTo(propertyTwo = this.getPropertyName(nameTwo));
        if (compare != 0) {
            return compare;
        }
        int prefixCodeOne = this.getPrefixCode(nameOne);
        if (prefixCodeOne < (prefixCodeTwo = this.getPrefixCode(nameTwo))) {
            return -1;
        }
        if (prefixCodeOne > prefixCodeTwo) {
            return 1;
        }
        return 0;
    }

    protected int getIndex(Object object) {
        return 0;
    }

    private String isBean(Object object) {
        Node data = ((SimpleNode)object).jjtGetChild(0);
        if (data instanceof ASTClassBodyDeclaration) {
            data = ((ASTClassBodyDeclaration)data).jjtGetChild(0);
        } else if (data instanceof ASTInterfaceMemberDeclaration) {
            data = ((ASTInterfaceMemberDeclaration)data).jjtGetChild(0);
        }
        if (data instanceof ASTEnumDeclaration) {
            return null;
        }
        if (data instanceof ASTFieldDeclaration) {
            return null;
        }
        if (data instanceof ASTConstructorDeclaration) {
            return null;
        }
        if (data instanceof ASTMethodDeclaration) {
            String name;
            ASTMethodDeclaration method = (ASTMethodDeclaration)data;
            if (method.jjtGetChild(0) instanceof ASTTypeParameters) {
                ASTMethodDeclarator decl = (ASTMethodDeclarator)method.jjtGetChild(2);
                name = decl.getName();
            } else {
                ASTMethodDeclarator decl = (ASTMethodDeclarator)method.jjtGetChild(1);
                name = decl.getName();
            }
            if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set")) && Character.isUpperCase(name.charAt(3))) {
                return name;
            }
            if (name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
                return name;
            }
            return null;
        }
        if (data instanceof ASTNestedInterfaceDeclaration) {
            return null;
        }
        if (data instanceof ASTNestedClassDeclaration) {
            return null;
        }
        return null;
    }

    private String getPrefix(String value) {
        if (value.startsWith("is")) {
            return "is";
        }
        return value.substring(0, 3);
    }

    private String getPropertyName(String value) {
        if (value.startsWith("is")) {
            return value.substring(2);
        }
        return value.substring(3);
    }

    private int getPrefixCode(String value) {
        String prefix = this.getPrefix(value);
        if (prefix.equals("is")) {
            return 3;
        }
        if (prefix.equals("set")) {
            return 2;
        }
        if (prefix.equals("get")) {
            return 1;
        }
        return 5;
    }
}

