/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.acm.seguin.pretty.sort.AlphabeticalOrder;
import org.acm.seguin.pretty.sort.BeanTogetherOrder;
import org.acm.seguin.pretty.sort.FieldInitializerOrder;
import org.acm.seguin.pretty.sort.FinalOrder;
import org.acm.seguin.pretty.sort.Ordering;
import org.acm.seguin.pretty.sort.ProtectionOrder;
import org.acm.seguin.pretty.sort.SetterGetterOrder;
import org.acm.seguin.pretty.sort.StaticOrder;
import org.acm.seguin.pretty.sort.TypeOrder;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.Settings;

public class MultipleOrdering
implements Comparator {
    private Ordering[] ordering;

    public MultipleOrdering(Settings settings) {
        int count = 0;
        try {
            while (true) {
                settings.getString("sort." + (count + 1));
                ++count;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            this.ordering = new Ordering[count];
            this.load(settings);
            return;
        }
    }

    public MultipleOrdering(String[] order) {
        this.ordering = new Ordering[order.length];
        int ndx = 0;
        while (ndx < order.length) {
            this.ordering[ndx] = this.parse(order[ndx]);
            ++ndx;
        }
    }

    public int compare(Object obj1, Object obj2) {
        int ndx = 0;
        while (ndx < this.ordering.length) {
            int comp = this.ordering[ndx].compare(obj1, obj2);
            if (comp != 0) {
                return comp;
            }
            ++ndx;
        }
        return 0;
    }

    private void load(Settings settings) {
        int ndx = 0;
        while (ndx < this.ordering.length) {
            String order = settings.getString("sort." + (ndx + 1));
            this.ordering[ndx] = this.parse(order);
            ++ndx;
        }
    }

    private Ordering parse(String order) {
        StringTokenizer tok = new StringTokenizer(order, "()");
        String name = tok.nextToken();
        String args = "";
        if (tok.hasMoreTokens()) {
            args = tok.nextToken();
        }
        if (name.equals("Type")) {
            return new TypeOrder(args);
        }
        if (name.equals("Class")) {
            return new StaticOrder(args);
        }
        if (name.equals("Protection")) {
            return new ProtectionOrder(args);
        }
        if (name.equals("Method")) {
            return new SetterGetterOrder(args);
        }
        if (name.equals("FieldInitializers")) {
            return new FieldInitializerOrder();
        }
        if (name.equals("Final")) {
            return new FinalOrder(args.equalsIgnoreCase("top"));
        }
        if (name.equals("Alphabetical")) {
            return new AlphabeticalOrder();
        }
        if (name.equals("Bean")) {
            return new BeanTogetherOrder();
        }
        return null;
    }
}

