/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTEnumDeclaration;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceMemberDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTNestedClassDeclaration;
import org.acm.seguin.parser.ast.ASTNestedInterfaceDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.sort.Ordering;

public class ProtectionOrder
extends Ordering {
    private boolean publicFirst;
    private static final int PUBLIC = 1;
    private static final int PROTECTED = 2;
    private static final int PACKAGE = 3;
    private static final int PRIVATE = 4;

    public ProtectionOrder(String ordering) {
        this.publicFirst = ordering.equalsIgnoreCase("public");
    }

    protected int getIndex(Object object) {
        Node data = ((SimpleNode)object).jjtGetChild(0);
        if (data instanceof ASTClassBodyDeclaration) {
            data = ((ASTClassBodyDeclaration)data).jjtGetChild(0);
        } else if (data instanceof ASTInterfaceMemberDeclaration) {
            data = ((ASTInterfaceMemberDeclaration)data).jjtGetChild(0);
        }
        int protection = 0;
        if (data instanceof ASTEnumDeclaration) {
            protection = this.getProtection(((ASTEnumDeclaration)data).getModifiers());
        } else if (data instanceof ASTFieldDeclaration) {
            protection = this.getProtection(((ASTFieldDeclaration)data).getModifiers());
        } else if (data instanceof ASTConstructorDeclaration) {
            protection = this.getProtection(((ASTConstructorDeclaration)data).getModifiers());
        } else if (data instanceof ASTMethodDeclaration) {
            protection = this.getProtection(((ASTMethodDeclaration)data).getModifiers());
        } else if (data instanceof ASTNestedInterfaceDeclaration) {
            protection = this.getProtection(((ASTNestedInterfaceDeclaration)data).getModifiers());
        } else if (data instanceof ASTNestedClassDeclaration) {
            protection = this.getProtection(((ASTNestedClassDeclaration)data).getModifiers());
        } else {
            return 100;
        }
        if (this.publicFirst) {
            return protection;
        }
        return -protection;
    }

    private int getProtection(ModifierHolder mods) {
        if (mods.isPrivate()) {
            return 4;
        }
        if (mods.isProtected()) {
            return 2;
        }
        if (mods.isPublic()) {
            return 1;
        }
        return 3;
    }

    static {
        PUBLIC = 1;
        PROTECTED = 2;
        PACKAGE = 3;
        PRIVATE = 4;
    }
}

