/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import java.util.StringTokenizer;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTTypeParameters;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.sort.Ordering;

public class SetterGetterOrder
extends Ordering {
    private int[] order = new int[3];
    private static final int SETTER = 1;
    private static final int GETTER = 2;
    private static final int OTHER = 3;

    public SetterGetterOrder(String ordering) {
        this.order[0] = 1;
        this.order[1] = 2;
        this.order[2] = 3;
        StringTokenizer tok = new StringTokenizer(ordering, ", \t");
        if (tok.hasMoreTokens()) {
            this.order[0] = this.getCode(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            this.order[1] = this.getCode(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            this.order[2] = this.getCode(tok.nextToken());
        }
    }

    protected int getIndex(Object object) {
        Node data = ((SimpleNode)object).jjtGetChild(0);
        if (data instanceof ASTMethodDeclaration) {
            ASTMethodDeclaration declaration = (ASTMethodDeclaration)data;
            int child = 1;
            if (declaration.jjtGetChild(0) instanceof ASTTypeParameters) {
                ++child;
            }
            ASTMethodDeclarator declar = (ASTMethodDeclarator)declaration.jjtGetChild(child);
            String name = declar.getName();
            return this.findCode(this.getCode(name));
        }
        return 100;
    }

    private int getCode(String val) {
        if (val.length() < 2) {
            return 3;
        }
        String shortValue = val.substring(0, 2);
        if (shortValue.equals("is")) {
            return 2;
        }
        if (val.length() < 3) {
            return 3;
        }
        shortValue = val.substring(0, 3);
        if (shortValue.equalsIgnoreCase("set")) {
            return 1;
        }
        if (shortValue.equalsIgnoreCase("get")) {
            return 2;
        }
        return 3;
    }

    private int findCode(int code) {
        int ndx = 0;
        while (ndx < 3) {
            if (this.order[ndx] == code) {
                return ndx;
            }
            ++ndx;
        }
        return 100;
    }

    static {
        SETTER = 1;
        GETTER = 2;
        OTHER = 3;
    }
}

