/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTClassDeclaration;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.sort.Ordering;

public class TopLevelOrdering
extends Ordering {
    private String[] importSortImportant;
    private String prefix;

    public TopLevelOrdering(ASTCompilationUnit node, PrintData data) {
        Node firstNode;
        String packageName = "";
        if (node.jjtGetNumChildren() > 0 && (firstNode = node.jjtGetChild(0)) instanceof ASTPackageDeclaration) {
            ASTName name = (ASTName)((ASTPackageDeclaration)firstNode).jjtGetChild(0);
            packageName = name.getName() + '.';
        }
        int current = -1;
        int periodCount = data.getImportSortNeighbourhood();
        if (periodCount > 0) {
            int ndx = 0;
            while (ndx < periodCount) {
                current = packageName.indexOf(46, current + 1);
                ++ndx;
            }
            this.prefix = current == -1 ? packageName : packageName.substring(0, current);
        } else {
            this.prefix = "";
        }
        this.importSortImportant = data.getImportSortImportant();
    }

    public int compare(Object one, Object two) {
        int twoIndex;
        int oneIndex = this.getIndex(one);
        if (oneIndex > (twoIndex = this.getIndex(two))) {
            return 1;
        }
        if (oneIndex < twoIndex) {
            return -1;
        }
        return this.fineCompare(one, two);
    }

    protected int getIndex(Object object) {
        if (object instanceof ASTPackageDeclaration) {
            return 1;
        }
        if (object instanceof ASTImportDeclaration) {
            return 2;
        }
        if (object instanceof ASTTypeDeclaration) {
            ASTTypeDeclaration type = (ASTTypeDeclaration)object;
            Node child = type.jjtGetChild(0);
            if (child instanceof ASTClassDeclaration) {
                ASTClassDeclaration classDecl = (ASTClassDeclaration)child;
                if (classDecl.isPublic()) {
                    return 3;
                }
                return 4;
            }
            ASTInterfaceDeclaration interfaceDecl = (ASTInterfaceDeclaration)child;
            if (interfaceDecl.isPublic()) {
                return 3;
            }
            return 4;
        }
        return 5;
    }

    private int compareImports(ASTImportDeclaration import1, ASTImportDeclaration import2) {
        String name2;
        String name1 = ((ASTName)import1.jjtGetChild(0)).getName();
        int result = this.compareImportsByNeighbourhood(name1, name2 = ((ASTName)import2.jjtGetChild(0)).getName());
        if (result == 0 && (result = this.compareImportsByPackagePrecedence(name1, name2)) == 0) {
            result = name1.compareTo(name2);
        }
        return result;
    }

    private int compareImportsByNeighbourhood(String name1, String name2) {
        return this.neighbourhoodOrder(name1) - this.neighbourhoodOrder(name2);
    }

    private int compareImportsByPackagePrecedence(String name1, String name2) {
        return this.packageOrder(name1) - this.packageOrder(name2);
    }

    private int fineCompare(Object obj1, Object obj2) {
        if (obj1 instanceof ASTImportDeclaration) {
            return this.compareImports((ASTImportDeclaration)obj1, (ASTImportDeclaration)obj2);
        }
        return 0;
    }

    private int neighbourhoodOrder(String name) {
        if (name.startsWith(this.prefix)) {
            return 1;
        }
        return 0;
    }

    private int packageOrder(String name) {
        if (this.importSortImportant == null) {
            return 0;
        }
        int matchLength = 0;
        int ord = this.importSortImportant.length;
        int ndx = 0;
        while (ndx < this.importSortImportant.length) {
            int currentLength;
            if (this.importSortImportant[ndx] != null && name.startsWith(this.importSortImportant[ndx]) && (currentLength = this.importSortImportant[ndx].length()) > matchLength) {
                ord = ndx;
                matchLength = currentLength;
            }
            ++ndx;
        }
        return ord;
    }
}

