/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public abstract class PagePrinter
implements Printable {
    private int filenameFontSize = 14;
    private int datePageFontSize = 8;
    protected static int headerHeight = 30;
    protected static PageFormat pf;
    private static double scale;

    public void setFilenameFontSize(int value) {
        this.filenameFontSize = value;
    }

    public void setDatePageCountFontSize(int value) {
        this.datePageFontSize = value;
    }

    protected void printHeader(Graphics g, String title, String pageNumber, String pageCount) {
        int x = (int)pf.getImageableX();
        int y = (int)pf.getImageableY();
        int wide = (int)pf.getImageableWidth();
        int high = headerHeight;
        g.setColor(Color.white);
        g.fillRect(x, y, wide - 1, high - 1);
        g.setColor(Color.black);
        g.drawRect(x, y, wide - 1, high - 1);
        int quarterWide = wide / 4;
        g.drawLine(x + 2 * quarterWide, y, x + 2 * quarterWide, y + headerHeight - 1);
        g.drawLine(x + 3 * quarterWide, y, x + 3 * quarterWide, y + headerHeight - 1);
        int centerY = y + headerHeight / 2;
        g.setFont(new Font("Serif", 1, this.filenameFontSize));
        FontMetrics fm = g.getFontMetrics();
        int tempY = y + (headerHeight + fm.getAscent() + fm.getDescent()) / 2 - fm.getDescent();
        if (title != null && title.length() > 0) {
            g.drawString(title, x + 10, tempY);
        }
        g.setFont(new Font("Serif", 1, this.datePageFontSize));
        fm = g.getFontMetrics();
        String now = DateFormat.getDateTimeInstance().format(new Date());
        tempY = y + (headerHeight + fm.getAscent() + fm.getDescent()) / 2 - fm.getDescent();
        g.drawString(now, x + 5 * quarterWide / 2 - fm.stringWidth(now) / 2, tempY);
        String pages = pageNumber + " of " + pageCount;
        g.drawString(pages, x + 7 * quarterWide / 2 - fm.stringWidth(pages) / 2, tempY);
    }

    public static void setHeaderHeight(int value) {
        headerHeight = value;
    }

    public static PageFormat getPageFormat(boolean dialog) {
        if (dialog) {
            PrinterJob job = PrinterJob.getPrinterJob();
            pf = job.pageDialog(job.defaultPage());
        }
        try {
            FileSettings bundle = FileSettings.getRefactorySettings("printing");
            PagePrinter.setHeaderHeight(Integer.parseInt(bundle.getString("header.space")));
        }
        catch (MissingSettingsException mre) {
            ExceptionPrinter.print(mre, true);
        }
        catch (NumberFormatException inf) {
            ExceptionPrinter.print(inf, true);
        }
        return pf;
    }

    public static int getPageWidth() {
        if (pf == null) {
            return -1;
        }
        return (int)(pf.getImageableWidth() / scale);
    }

    public static int getPageHeight() {
        if (pf == null) {
            return -1;
        }
        return (int)(pf.getImageableHeight() / scale);
    }

    protected static void setScale(double value) {
        scale = value;
    }

    protected static double getScale() {
        return scale;
    }

    static {
        scale = 1.0;
    }
}

