/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrintingSettings {
    private int textFontSize;
    private int textSpace;
    private int headerBlock;
    private int filenameFont;
    private int dateFont;
    private int linesPerPage;

    public PrintingSettings() {
        this.init();
    }

    public void setTextFontSize(int value) {
        if (value != this.textFontSize) {
            this.textFontSize = value;
            this.save();
        }
    }

    public void setTextSpace(int value) {
        if (value != this.textSpace) {
            this.textSpace = value;
            this.save();
        }
    }

    public void setHeaderBlockHeight(int value) {
        if (value != this.headerBlock) {
            this.headerBlock = value;
            this.save();
        }
    }

    public void setFilenameFontSize(int value) {
        if (value != this.filenameFont) {
            this.filenameFont = value;
            this.save();
        }
    }

    public void setDateFontSize(int value) {
        if (value != this.dateFont) {
            this.dateFont = value;
            this.save();
        }
    }

    public void setLinesPerPage(int value) {
        if (this.linesPerPage != value) {
            this.linesPerPage = value;
            this.save();
        }
    }

    public int getTextFontSize() {
        return this.textFontSize;
    }

    public int getTextSpace() {
        return this.textSpace;
    }

    public int getHeaderBlockHeight() {
        return this.headerBlock;
    }

    public int getFilenameFontSize() {
        return this.filenameFont;
    }

    public int getDateFontSize() {
        return this.dateFont;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public void save() {
        try {
            File directory = FileSettings.getRefactorySettingsRoot();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            FileWriter output = new FileWriter(new File(directory, "printing.settings"));
            PrintWriter printer = new PrintWriter(output);
            this.write(printer);
            printer.close();
            output.close();
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
    }

    private void defaults() {
        this.textFontSize = 10;
        this.textSpace = 0;
        this.headerBlock = 30;
        this.filenameFont = 14;
        this.dateFont = 8;
        this.linesPerPage = 36;
    }

    private void init() {
        this.defaults();
        try {
            FileSettings setting = FileSettings.getRefactorySettings("printing");
            this.textFontSize = setting.getInteger("text.font.size");
            this.textSpace = setting.getInteger("text.space");
            this.headerBlock = setting.getInteger("header.space");
            this.filenameFont = setting.getInteger("filename.font.size");
            this.dateFont = setting.getInteger("date.font.size");
            this.linesPerPage = setting.getInteger("lines.per.page");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }

    private void write(PrintWriter printer) {
        printer.println("#  This is the font size for the text of the file");
        printer.println("text.font.size=" + this.textFontSize);
        printer.println(" ");
        printer.println("#  This is the number of pixels to skip between");
        printer.println("#  lines in the text of the file");
        printer.println("text.space=" + this.textSpace);
        printer.println(" ");
        printer.println("#  The header block is 30 pixels high");
        printer.println("header.space=" + this.headerBlock);
        printer.println(" ");
        printer.println("#  The name of the file is specified with this parameter");
        printer.println("filename.font.size=" + this.filenameFont);
        printer.println(" ");
        printer.println("#  The date that the file was printed and the number");
        printer.println("#  of pages is in this font size");
        printer.println("date.font.size=" + this.dateFont);
        printer.println(" ");
        printer.println("#  The number of lines on a page.  This is an estimate");
        printer.println("#  that is updated by the software each time a new set of");
        printer.println("#  values is changed");
        printer.println("lines.per.page=" + this.linesPerPage);
    }
}

