/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.TextPagePrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrintingThread
extends Thread {
    private String data;
    private LinePrinter printer;
    private String filename;

    public PrintingThread(String filename, String init, LinePrinter printer) {
        this.data = init;
        this.printer = printer;
        this.filename = filename;
    }

    public void run() {
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        TextPagePrinter textpp = new TextPagePrinter(this.filename, this.data, this.printer);
        this.loadDefaults(textpp);
        PageFormat pf = TextPagePrinter.getPageFormat(false);
        if (pf == null) {
            pf = TextPagePrinter.getPageFormat(true);
        }
        int count = textpp.calculatePageCount(pf);
        book.append(textpp, pf, count);
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Throwable ex) {
                ExceptionPrinter.print(ex, false);
            }
        }
    }

    private void loadDefaults(TextPagePrinter textpp) {
        try {
            FileSettings bundle = FileSettings.getRefactorySettings("printing");
            textpp.setTextFontSize(Integer.parseInt(bundle.getString("text.font.size")));
            textpp.setBetweenLineSpacing(Integer.parseInt(bundle.getString("text.space")));
            textpp.setFilenameFontSize(Integer.parseInt(bundle.getString("filename.font.size")));
            textpp.setDatePageCountFontSize(Integer.parseInt(bundle.getString("date.font.size")));
        }
        catch (MissingSettingsException mre) {
            ExceptionPrinter.print(mre, false);
        }
        catch (NumberFormatException inf) {
            ExceptionPrinter.print(inf, false);
        }
    }

    public static void main(String[] args) {
        try {
            FileReader in = new FileReader(args[0]);
            BufferedReader input = new BufferedReader(in);
            StringBuffer all = new StringBuffer();
            String line = input.readLine();
            while (line != null) {
                all.append(line);
                all.append("\n");
                line = input.readLine();
            }
            input.close();
            new PrintingThread(args[0], all.toString(), new LinePrinter()).run();
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
    }
}

