/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.LineSet;
import org.acm.seguin.util.TextFormatter;

public class PropertyLinePrinter
extends LinePrinter {
    private Font lineNo = null;
    private Font normal = null;
    private Font keyword = null;
    private Font comment = null;

    public void setFontSize(int value) {
        if (this.fontSize != value) {
            super.setFontSize(value);
            this.normal = null;
            this.keyword = null;
            this.comment = null;
            this.lineNo = null;
        }
    }

    public void init(Graphics g) {
        if (this.normal == null) {
            this.normal = new Font("SansSerif", 0, this.fontSize);
            this.keyword = new Font("SansSerif", 1, this.fontSize);
            this.comment = new Font("SansSerif", 2, this.fontSize);
            this.lineNo = new Font("Monospaced", 0, this.fontSize);
        }
        g.setColor(Color.black);
        g.setFont(this.normal);
    }

    public void print(Graphics g, String line, int x, int y, LineSet set, int index) {
        String output = TextFormatter.rightJustifyNumber(index + 1, 5) + ":  ";
        g.setFont(this.lineNo);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(output, x, y);
        x += fm.stringWidth(output);
        if (line.length() < 1) {
            return;
        }
        if (line.charAt(0) == '#') {
            g.setFont(this.comment);
            g.drawString(line, x, y);
            return;
        }
        int equalsIndex = line.indexOf(61);
        if (equalsIndex > 0) {
            String keywordString = line.substring(0, equalsIndex);
            String valueString = line.substring(equalsIndex + 1);
            g.setFont(this.keyword);
            g.drawString(keywordString, x, y);
            fm = g.getFontMetrics();
            g.setColor(Color.gray);
            g.drawString("=", x += fm.stringWidth(keywordString), y);
            g.setFont(this.normal);
            g.setColor(Color.black);
            g.drawString(valueString, x += fm.stringWidth("="), y);
            return;
        }
        g.drawString(line, x, y);
    }
}

