/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import org.acm.seguin.print.PagePrinter;
import org.acm.seguin.print.PrintingSettings;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.LineSet;

public class TextPagePrinter
extends PagePrinter {
    private String filename;
    private LineSet lineSet;
    private LinePrinter linePrinter;
    private int textFontSize = 10;
    private int textSkip = 2;
    private static int linesPerPage = -1;

    public TextPagePrinter(String initFilename, String init, LinePrinter printer) {
        this.lineSet = new LineSet(init);
        this.linePrinter = printer;
        this.filename = initFilename;
    }

    public void setTextFontSize(int value) {
        this.textFontSize = value;
    }

    public void setBetweenLineSpacing(int value) {
        this.textSkip = value;
    }

    public int calculatePageCount(PageFormat pf) {
        int pageHeight = (int)pf.getImageableHeight();
        int pageWidth = (int)pf.getImageableWidth();
        int lpp = linesPerPage;
        int lineCount = this.lineSet.size();
        if (linesPerPage == -1) {
            PrintingSettings ps = new PrintingSettings();
            lpp = ps.getLinesPerPage();
        }
        int pagesHigh = lineCount / lpp;
        if (lineCount % lpp != 0) {
            ++pagesHigh;
        }
        return pagesHigh;
    }

    public int print(Graphics g, PageFormat pf, int pageNumber) {
        int pageCount = this.calculatePageCount(pf);
        if (pageNumber > pageCount) {
            return 1;
        }
        this.linePrinter.setFontSize(this.textFontSize);
        int high = this.linePrinter.getLineHeight(g) + this.textSkip;
        if (linesPerPage == -1) {
            int pageHeight = (int)pf.getImageableHeight() - PagePrinter.headerHeight;
            linesPerPage = pageHeight / high;
            PrintingSettings ps = new PrintingSettings();
            ps.setLinesPerPage(linesPerPage);
        }
        int startIndex = pageNumber * linesPerPage;
        int xOffset = (int)pf.getImageableX();
        int yOffset = (int)pf.getImageableY() + PagePrinter.headerHeight;
        this.printHeader(g, this.filename, "" + (1 + pageNumber), "" + pageCount);
        this.linePrinter.init(g);
        int ndx = 0;
        while (ndx < linesPerPage) {
            int index = ndx + pageNumber * linesPerPage;
            String line = this.lineSet.getLine(index);
            if (line == null) break;
            this.linePrinter.print(g, line, xOffset, yOffset + (1 + ndx) * high, this.lineSet, index);
            ++ndx;
        }
        return 0;
    }
}

