/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.parser.factory.StdInParserFactory;
import org.acm.seguin.pretty.PrettyPrintVisitor;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.line.LineNumberingData;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;

public class LineNumberTool {
    private String dest = null;
    private ArrayList inputList = new ArrayList();
    private OutputStream out = null;

    protected void init(String[] args) {
        int last = args.length;
        int ndx = 0;
        while (ndx < last) {
            if (args[ndx].equals("-help")) {
                System.out.println("Pretty Printer Version 1.0.  Has the following inputs");
                System.out.println("         java LineNumberTool [-out filename] (inputfile)*");
                System.out.println("OR");
                System.out.println("         java LineNumberTool [-out filename] < inputfile");
                System.out.println("where");
                System.out.println("         -out filename     Output to the file or directory");
            } else if (args[ndx].equals("-out")) {
                this.dest = args[++ndx];
            } else {
                this.inputList.add(args[ndx]);
            }
            ++ndx;
        }
    }

    protected void run() {
        int last = this.inputList.size();
        PrettyPrintVisitor printer = new PrettyPrintVisitor();
        PrintData data = null;
        int index = 0;
        while (index < last || index == 0) {
            data = this.getPrintData(index, data);
            printer.visit(this.getRoot(index), (Object)data);
            data.flush();
            ++index;
        }
        data.close();
    }

    private OutputStream getOutputStream(int index, String filename) {
        OutputStream out = null;
        if (this.dest == null) {
            out = System.out;
        } else {
            try {
                out = new FileOutputStream(this.dest);
            }
            catch (IOException ioe) {
                out = System.out;
            }
        }
        return out;
    }

    private PrintData getPrintData(int index, PrintData oldPrintData) {
        if (oldPrintData == null) {
            this.out = this.getOutputStream(index, null);
            return new LineNumberingData(this.out);
        }
        oldPrintData.flush();
        try {
            this.out.write(12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return oldPrintData;
    }

    private SimpleNode getRoot(int index) {
        ParserFactory factory;
        if (this.inputList.size() > index) {
            File in = new File((String)this.inputList.get(index));
            factory = new FileParserFactory(in);
        } else {
            factory = new StdInParserFactory();
        }
        return factory.getAbstractSyntaxTree(true);
    }

    public static void main(String[] args) {
        int ndx = 0;
        while (ndx < args.length) {
            if (args[ndx].equals("-config")) {
                String dir = args[ndx + 1];
                ++ndx;
                FileSettings.setSettingsRoot(dir);
            }
            ++ndx;
        }
        new RefactoryInstaller(false).run();
        try {
            LineNumberTool pp = new LineNumberTool();
            pp.init(args);
            pp.run();
        }
        catch (Throwable t) {
            if (t == null) {
                System.out.println("We have caught a null throwable");
            }
            System.out.println("t is a " + t.getClass().getName());
            System.out.println("t has a message " + t.getMessage());
            t.printStackTrace(System.out);
        }
    }
}

