/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import org.acm.seguin.metrics.CommaDelimitedReport;
import org.acm.seguin.metrics.GatherData;
import org.acm.seguin.metrics.MetricsReport;
import org.acm.seguin.metrics.ProjectMetrics;
import org.acm.seguin.metrics.TextReport;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.summary.load.LoadStatus;
import org.acm.seguin.summary.load.SilentLoadStatus;
import org.acm.seguin.summary.load.TextLoadStatus;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;

public class Metrics {
    public static void main(String[] args) {
        String startDir = System.getProperty("user.dir");
        boolean type = false;
        TextLoadStatus status = new TextLoadStatus();
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equals("-help")) {
                System.out.println("Syntax:  java Metrics [-text|-comma] [dir]");
                return;
            }
            if (args[argIndex].equals("-text")) {
                type = false;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equals("-comma")) {
                type = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equals("-quiet")) {
                status = new SilentLoadStatus();
                ++argIndex;
                continue;
            }
            if (args[argIndex].equals("-config")) {
                String dir = args[argIndex + 1];
                ++argIndex;
                FileSettings.setSettingsRoot(dir);
                continue;
            }
            startDir = args[argIndex];
            ++argIndex;
        }
        new RefactoryInstaller(false).run();
        new SummaryTraversal(startDir, (LoadStatus)status).run();
        Object metricsReport = !type ? new TextReport() : new CommaDelimitedReport();
        GatherData visitor = new GatherData((MetricsReport)metricsReport);
        ProjectMetrics projectData = (ProjectMetrics)visitor.visit((Object)"");
        metricsReport.finalReport(projectData);
    }
}

