/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import java.io.File;
import javax.swing.JFileChooser;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.awt.TextExceptionPrinter;
import org.acm.seguin.io.AllFileFilter;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.io.ExtensionFileFilter;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrettyPrinter
extends DirectoryTreeTraversal {
    private PrettyPrintFile ppf;

    public PrettyPrinter(String init, boolean quiet) {
        super(init);
        if (init == null) {
            return;
        }
        this.ppf = new PrettyPrintFile();
        this.ppf.setAsk(!quiet && new File(init).isDirectory());
    }

    protected boolean isTarget(File currentFile) {
        return currentFile.getName().endsWith(".java");
    }

    protected void visit(File currentFile) {
        if (this.ppf.isApplicable(currentFile)) {
            System.out.println("Applying the Pretty Printer:  " + currentFile.getPath());
            this.makeBackup(currentFile);
            this.ppf.apply(currentFile);
        }
    }

    private void makeBackup(File currentFile) {
        String backupExt;
        try {
            backupExt = FileSettings.getRefactoryPrettySettings().getString("pretty.printer.backup.ext");
            backupExt = backupExt == null ? "" : backupExt.trim();
        }
        catch (MissingSettingsException mse) {
            backupExt = "";
        }
        if (backupExt != null && backupExt.length() > 0) {
            File parentDir = currentFile.getParentFile();
            String name = currentFile.getName();
            File dest = new File(parentDir, name + backupExt);
            new FileCopy(currentFile, dest, false).run();
        }
    }

    public static void main(String[] args) {
        try {
            int lastOption = -1;
            boolean quiet = false;
            int ndx = 0;
            while (ndx < args.length) {
                if (args[ndx].equals("-quiet") || args[ndx].equals("-u")) {
                    quiet = true;
                    lastOption = ndx;
                    ExceptionPrinter.register(new TextExceptionPrinter());
                } else {
                    if (args[ndx].equals("-?") || args[ndx].equalsIgnoreCase("-h") || args[ndx].equalsIgnoreCase("-help")) {
                        PrettyPrinter.printHelpMessage();
                        return;
                    }
                    if (args[ndx].equals("-config")) {
                        String dir = args[ndx + 1];
                        ++ndx;
                        FileSettings.setSettingsRoot(dir);
                    }
                }
                ++ndx;
            }
            new RefactoryInstaller(false).run();
            if (lastOption + 1 >= args.length) {
                if (quiet) {
                    PrettyPrinter.prettyPrinter(quiet);
                } else {
                    PrettyPrinter.prettyPrinter(System.getProperty("user.dir"), quiet);
                }
            } else {
                int ndx2 = lastOption + 1;
                while (ndx2 < args.length) {
                    PrettyPrinter.prettyPrinter(args[ndx2], quiet);
                    ++ndx2;
                }
            }
        }
        catch (Throwable thrown) {
            thrown.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(ExceptionPrinter.getExceptionsPrinted());
    }

    public static void prettyPrinter(String filename, boolean quiet) {
        new PrettyPrinter(filename, quiet).run();
    }

    public static void prettyPrinter(boolean quiet) {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension(".java");
        filter.setDescription("Java Source Files (.java)");
        chooser.setFileFilter(filter);
        AllFileFilter allFilter = new AllFileFilter();
        chooser.addChoosableFileFilter(allFilter);
        chooser.setFileSelectionMode(2);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            new PrettyPrinter(chooser.getSelectedFile().getAbsolutePath(), quiet).run();
        }
    }

    private static void printHelpMessage() {
        System.out.println("Syntax:  java PrettyPrinter file   //  means refactor this file");
        System.out.println("   OR    java PrettyPrinter [-quiet|-u] dir   //  means refactor this directory");
        System.out.println("   OR    java PrettyPrinter [-quiet|-u]   //  means refactor the current directory");
        System.out.println("  the -quiet or the -u flag tells the pretty printer not to prompt the user");
    }
}

