/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import java.io.File;
import javax.swing.JFileChooser;
import org.acm.seguin.ide.command.CommandLineSourceBrowser;
import org.acm.seguin.ide.command.PackageSelectorPanel;
import org.acm.seguin.ide.common.SourceBrowser;
import org.acm.seguin.io.AllFileFilter;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.uml.loader.Reloader;
import org.acm.seguin.uml.loader.ReloaderSingleton;
import org.acm.seguin.util.FileSettings;

public class Refactory {
    public static void main(String[] args) {
        int ndx = 0;
        while (ndx < args.length) {
            if (args[ndx].equals("-config")) {
                String dir = args[ndx + 1];
                ++ndx;
                FileSettings.setSettingsRoot(dir);
            }
            ++ndx;
        }
        new RefactoryInstaller(true).run();
        SourceBrowser.set((SourceBrowser)new CommandLineSourceBrowser());
        if (args.length == 0) {
            Refactory.elixir();
        } else {
            Refactory.selectionPanel(args[0]);
        }
    }

    public static void selectionPanel(String directory) {
        PackageSelectorPanel panel = PackageSelectorPanel.openMainFrame((String)directory);
        ReloaderSingleton.register((Reloader)panel);
    }

    public static void elixir() {
        if (PackageSelectorPanel.openMainFrame(null) != null) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        AllFileFilter allFilter = new AllFileFilter();
        chooser.addChoosableFileFilter(allFilter);
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            Refactory.selectionPanel(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

