/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.RenameClassRefactoring;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;

public class RenameType {
    private RenameClassRefactoring renameClass;

    public boolean init(String[] args) {
        int nCurrentArg = 0;
        while (nCurrentArg < args.length) {
            if (args[nCurrentArg].equalsIgnoreCase("-dir")) {
                this.renameClass.setDirectory(args[nCurrentArg + 1]);
                nCurrentArg += 2;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-help") || args[nCurrentArg].equalsIgnoreCase("--help")) {
                this.printHelpMessage();
                ++nCurrentArg;
                return false;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-from")) {
                this.renameClass.setOldClassName(args[nCurrentArg + 1]);
                nCurrentArg += 2;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-to")) {
                this.renameClass.setNewClassName(args[nCurrentArg + 1]);
                nCurrentArg += 2;
                continue;
            }
            System.out.println("Unknown argument:  " + args[nCurrentArg]);
            ++nCurrentArg;
        }
        return true;
    }

    public void run(String[] args) {
        this.renameClass = RefactoringFactory.get().renameClass();
        if (args.length == 0) {
            this.printHelpMessage();
        }
        try {
            if (this.init(args)) {
                try {
                    this.renameClass.run();
                }
                catch (RefactoringException re) {
                    System.out.println(re.getMessage());
                }
            }
        }
        catch (Exception aoe) {
            this.printHelpMessage();
        }
    }

    protected void printHelpMessage() {
        System.out.println("Syntax:  java RenameType \\ ");
        System.out.println("        [-dir <dir>] [-help | --help] ");
        System.out.println("        -from <className> -to <className>");
        System.out.println("");
        System.out.println("  where:");
        System.out.println("    <dir>        is the name of the directory containing the files");
        System.out.println("    <className>  is the name of the class");
        System.out.println("    The syntax is case insensitive. ");
    }

    public static void main(String[] args) {
        try {
            int ndx = 0;
            while (ndx < args.length) {
                if (args[ndx].equals("-config")) {
                    String dir = args[ndx + 1];
                    ++ndx;
                    FileSettings.setSettingsRoot(dir);
                }
                ++ndx;
            }
            new RefactoryInstaller(true).run();
            new RenameType().run(args);
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        System.exit(0);
    }
}

