/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.builder;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.MoveClass;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;

public class Repackage {
    private boolean setPackage = false;
    private boolean atLeastOneClass = false;
    private MoveClass moveClass;

    public boolean init(String[] args) {
        int nCurrentArg = 0;
        while (nCurrentArg < args.length) {
            if (args[nCurrentArg].equalsIgnoreCase("-dir")) {
                this.moveClass.setDirectory(args[nCurrentArg + 1]);
                nCurrentArg += 2;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-package")) {
                this.moveClass.setDestinationPackage(args[nCurrentArg + 1]);
                nCurrentArg += 2;
                this.setPackage = true;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-nopackage")) {
                this.moveClass.setDestinationPackage("");
                ++nCurrentArg;
                this.setPackage = true;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-file")) {
                String filename = args[nCurrentArg + 1];
                this.load(filename);
                nCurrentArg += 2;
                this.atLeastOneClass = true;
                continue;
            }
            if (args[nCurrentArg].equalsIgnoreCase("-help") || args[nCurrentArg].equalsIgnoreCase("--help")) {
                this.printHelpMessage();
                ++nCurrentArg;
                return false;
            }
            this.moveClass.add(args[nCurrentArg]);
            ++nCurrentArg;
            this.atLeastOneClass = true;
        }
        return this.atLeastOneClass && this.setPackage;
    }

    public void run(String[] args) throws RefactoringException {
        this.moveClass = RefactoringFactory.get().moveClass();
        if (args.length == 0) {
            this.printHelpMessage();
        }
        try {
            if (this.init(args)) {
                this.moveClass.run();
            }
        }
        catch (Exception aoe) {
            this.printHelpMessage();
        }
    }

    protected void printHelpMessage() {
        System.out.println("Syntax:  java Repackage \\ ");
        System.out.println("        [-dir <dir>] [-help | --help] ");
        System.out.println("        [-package <packagename> | -nopackage] (<file.java>)*");
        System.out.println("");
        System.out.println("  where:");
        System.out.println("    <dir>        is the name of the directory containing the files");
        System.out.println("    <package>    is the name of the new package");
        System.out.println("    <nopackage>  is the way of flatening package hieracrhy");
        System.out.println("    <file.java>  is the name of the java file(s) separated");
        System.out.println("                 by whitespace to be moved");
        System.out.println("    The syntax is case insensitive. ");
    }

    private void load(String filename) {
        try {
            BufferedReader input = new BufferedReader(new FileReader(filename));
            String line = input.readLine();
            if (line == null) {
                System.out.println("Should have atleast one file name");
                this.printHelpMessage();
            }
            while (line != null) {
                StringTokenizer tok = new StringTokenizer(line);
                while (tok.hasMoreTokens()) {
                    String next = tok.nextToken();
                    System.out.println("Adding:  " + next);
                    this.moveClass.add(next);
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            int ndx = 0;
            while (ndx < args.length) {
                if (args[ndx].equals("-config")) {
                    String dir = args[ndx + 1];
                    ++ndx;
                    FileSettings.setSettingsRoot(dir);
                }
                ++ndx;
            }
            new RefactoryInstaller(true).run();
            new Repackage().run(args);
        }
        catch (Throwable thrown) {
            thrown.printStackTrace(System.out);
        }
        System.exit(0);
    }
}

