/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.PrintWriter;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.util.MissingSettingsException;

class AlphabeticalOrderPanel
extends SortSettingPanel {
    public AlphabeticalOrderPanel() {
        this.addDescription("Order methods and fields in alphabetical order");
        this.addListener();
        this.setSortEnabled(this.findProperty("Alphabetical"));
    }

    public void reload() {
        this.setSortEnabled(this.findProperty("Alphabetical"));
    }

    protected String getSortName() {
        return "Alphabetical";
    }

    public void generateSetting(PrintWriter output, int index) {
        this.printDescription(output);
        if (!this.isSortEnabled()) {
            output.print("#");
        }
        output.println("sort." + index + "=Alphabetical()");
        output.println("");
    }

    protected boolean findProperty(String key) {
        try {
            int index = 1;
            while (index < 50) {
                String value = SettingPanel.bundle.getString("sort." + index);
                if (value.startsWith(key)) {
                    this.setOrder(index);
                    return true;
                }
                ++index;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return false;
    }
}

