/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.acm.seguin.awt.OrderableList;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.SortSettingPanel;
import org.acm.seguin.util.MissingSettingsException;

abstract class ListOrderPanel
extends SortSettingPanel {
    private OrderableList list;

    public abstract void generateSetting(PrintWriter var1, int var2);

    protected StringTokenizer findProperty(String key, String defaultValues) {
        try {
            int index = 1;
            while (index < 50) {
                String value = SettingPanel.bundle.getString("sort." + index);
                StringTokenizer tok = new StringTokenizer(value, "(), \t");
                if (tok.nextToken().equalsIgnoreCase(key)) {
                    this.setSortEnabled(true);
                    this.setOrder(index);
                    return tok;
                }
                ++index;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        this.setSortEnabled(false);
        return new StringTokenizer(defaultValues, "(),");
    }

    protected abstract String[] loadOriginalArray();

    protected void addControl() {
        this.incrItems();
        Object[] data = this.loadOriginalArray();
        this.list = new OrderableList(data, null);
        ++this.constraints.gridy;
        this.add(this.list, this.constraints);
    }

    protected void generateSetting(PrintWriter output, int index, String key) {
        this.printDescription(output);
        if (!this.isSortEnabled()) {
            output.print("#");
        }
        output.print("sort." + index + "=" + key + "(");
        Object[] data = this.list.getData();
        int ndx = 0;
        while (ndx < data.length) {
            output.print(data[ndx].toString());
            if (ndx != data.length - 1) {
                output.print(",");
            }
            ++ndx;
        }
        output.println(")");
        output.println("");
    }

    public void reload() {
        this.list.resetModel(this.loadOriginalArray());
    }
}

