/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.util.MissingSettingsException;

public abstract class MultilineSettingPanel
extends SettingPanel {
    private JTextArea textArea;

    public MultilineSettingPanel() {
        this.setLayout(new GridBagLayout());
    }

    public String getDefaultValue() {
        int count = 1;
        boolean possible = true;
        StringBuffer result = new StringBuffer();
        while (possible) {
            try {
                result.append(SettingPanel.bundle.getString(this.getKey() + "." + count));
                result.append("\n");
                ++count;
            }
            catch (MissingSettingsException mse) {
                possible = false;
            }
        }
        return result.toString();
    }

    public String getValue() {
        return this.textArea.getText();
    }

    public void addControl() {
        this.textArea = new JTextArea();
        this.textArea.setText(this.getDefaultValue());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.textArea.setBorder(new EtchedBorder());
        this.add((Component)this.textArea, constraints);
    }

    public void generateSetting(PrintWriter output) {
        this.printDescription(output);
        StringTokenizer tok = new StringTokenizer(this.textArea.getText(), "\r\n");
        int count = 1;
        while (tok.hasMoreTokens()) {
            output.println(this.getKey() + "." + count + "=" + this.addEscapes(tok.nextToken()));
            ++count;
        }
        output.println("");
    }

    public void reload() {
        this.textArea.setText(this.getDefaultValue());
    }

    protected String getInitialValue() {
        return "";
    }

    private String addEscapes(String line) {
        StringBuffer l_sbBuffer = new StringBuffer();
        int ndx = 0;
        while (ndx < line.length()) {
            if (line.charAt(ndx) == '\\') {
                l_sbBuffer.append("\\\\");
            } else {
                l_sbBuffer.append(line.charAt(ndx));
            }
            ++ndx;
        }
        return l_sbBuffer.toString();
    }
}

