/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class PrettySettingsParser {
    private String filename;
    private LinkedList list = new LinkedList();

    public void setFilename(String value) {
        this.filename = value;
    }

    public void run() {
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.filename));
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    this.list.clear();
                } else if (line.charAt(0) == '#') {
                    this.addToDescription(line);
                } else {
                    this.processKey(line);
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    private boolean isIndexedOption(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    private void processKey(String line) throws IOException {
        int equalsLocation = line.indexOf(61);
        String key = line.substring(0, equalsLocation);
        String value = line.substring(equalsLocation + 1).trim();
        if (key.equals("version")) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(key, ".");
        StringBuffer buffer = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            buffer.append(Character.toUpperCase(next.charAt(0)));
            buffer.append(next.substring(1));
        }
        buffer.append("Panel");
        String name = buffer.toString();
        String classExtension = "TextPanel";
        String currentValue = value.trim().toLowerCase();
        if (currentValue.equals("true") || currentValue.equals("false")) {
            classExtension = "TogglePanel";
        } else if (this.containsOption()) {
            classExtension = "OptionPanel";
        } else if (this.isIndexedOption(currentValue)) {
            classExtension = "IndexedPanel";
        }
        PrintWriter output = new PrintWriter(new FileWriter(name + ".java"));
        output.println("package org.acm.seguin.tools.install;");
        output.println("public class " + name + " extends " + classExtension + "{");
        output.println("\tpublic " + name + "() {");
        output.println("\t\tsuper();");
        this.printDescription(output);
        output.println("\t\taddControl();");
        output.println("\t}");
        output.println("\tpublic String getKey() { return \"" + key + "\"; }");
        output.println("\tprotected String getInitialValue() { return \"" + value + "\"; }");
        output.println("}");
        output.flush();
        output.close();
    }

    private void printDescription(PrintWriter output) {
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if ((next = next.trim()).charAt(0) == '*') {
                int indexMinus = next.indexOf(45);
                String key = next.substring(1, indexMinus).trim();
                String descr = next.substring(indexMinus + 1).trim();
                output.println("\t\taddOption(\"" + key + "\", \"" + descr + "\");");
                continue;
            }
            output.println("\t\taddDescription(\"" + next + "\");");
        }
    }

    private boolean containsOption() {
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if (next.indexOf("*") < 0) continue;
            return true;
        }
        return false;
    }

    private void addToDescription(String line) {
        String message = line.substring(1);
        if (message != null && message.trim().length() != 0) {
            this.list.add(message);
        }
    }

    public static void main(String[] args) {
        new RefactoryInstaller(false).run();
        PrettySettingsParser psp = new PrettySettingsParser();
        psp.setFilename(args[0]);
        psp.run();
    }
}

