/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.print.PrintingSettings;
import org.acm.seguin.tools.install.PrettyPrinterConfigGUI;
import org.acm.seguin.tools.stub.StubPrompter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class RefactoryInstaller
implements Runnable {
    private boolean refactory;
    public static final double PRETTY_CURRENT_VERSION = 3.8;
    private static final double UML_CURRENT_VERSION = 1.2;

    public RefactoryInstaller(boolean forRefactory) {
        this.refactory = forRefactory;
    }

    public void run() {
        try {
            String temp;
            double version;
            FileSettings bundle;
            PrintWriter printer;
            FileWriter output;
            File file;
            File oldLogFile;
            File oldUndoStack;
            File homeDir = FileSettings.getSettingsRoot();
            File directory = FileSettings.getRefactorySettingsRoot();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if ((oldUndoStack = new File(homeDir, "undo.stk")).exists()) {
                File dest = new File(directory, "undo.stk");
                new FileCopy(oldUndoStack, dest).run();
                oldUndoStack.delete();
            }
            if ((oldLogFile = new File(homeDir, "log.txt")).exists()) {
                File dest = new File(directory, "log.txt");
                new FileCopy(oldLogFile, dest).run();
                oldLogFile.delete();
            }
            if (!(file = new File(directory, "pretty.settings")).exists()) {
                output = new FileWriter(file);
                printer = new PrintWriter(output);
                this.prettySettings(printer, 0.0);
                printer.flush();
                output.flush();
                printer.close();
                output.close();
                bundle = FileSettings.getRefactoryPrettySettings();
                bundle.setReloadNow(true);
            } else {
                bundle = FileSettings.getRefactoryPrettySettings();
                bundle.setReloadNow(true);
                version = 1.0;
                try {
                    temp = bundle.getString("indent");
                }
                catch (MissingSettingsException mse) {
                    version = 0.5;
                }
                try {
                    version = bundle.getDouble("version");
                }
                catch (MissingSettingsException mse) {
                    // empty catch block
                }
                if (version < 3.75) {
                    output = new FileWriter(file.getPath(), true);
                    printer = new PrintWriter(output);
                    this.prettySettings(printer, version);
                    printer.flush();
                    output.flush();
                    printer.close();
                    output.close();
                }
                bundle.setReloadNow(true);
            }
            file = new File(directory, "uml.settings");
            if (!file.exists()) {
                output = new FileWriter(file);
                printer = new PrintWriter(output);
                this.umlSettings(printer, 0.0, homeDir);
                printer.close();
                output.close();
            } else {
                bundle = FileSettings.getRefactorySettings("uml");
                bundle.setReloadNow(true);
                version = 1.0;
                try {
                    temp = bundle.getString("stub.dir");
                }
                catch (MissingSettingsException mse) {
                    version = 0.5;
                }
                try {
                    version = bundle.getDouble("version");
                }
                catch (MissingSettingsException mse) {
                    // empty catch block
                }
                if (version < 1.15) {
                    output = new FileWriter(file.getPath(), true);
                    printer = new PrintWriter(output);
                    this.umlSettings(printer, version, homeDir);
                    printer.flush();
                    printer.close();
                }
            }
            file = new File(directory, "printing.settings");
            if (!file.exists()) {
                new PrintingSettings().save();
            }
            if (!(file = new File(directory, "vss.settings")).exists()) {
                output = new FileWriter(file);
                printer = new PrintWriter(output);
                this.vssSettings(printer);
                printer.close();
                output.close();
            }
            if (!(file = new File(directory, "process.settings")).exists()) {
                output = new FileWriter(file);
                printer = new PrintWriter(output);
                this.processSettings(printer);
                printer.close();
                output.close();
            }
            if (!(file = new File(directory, "creation.txt")).exists()) {
                this.generateCreationText(file);
            } else {
                GregorianCalendar created = new GregorianCalendar();
                created.setTime(new Date(file.lastModified()));
                GregorianCalendar lastMonth = new GregorianCalendar();
                lastMonth.add(2, -1);
                File logFile = new File(directory, "log.txt");
                if (lastMonth.after(created) && logFile.exists() && logFile.length() > 0L) {
                    this.generateCreationText(file);
                    String message = "Chris Seguin wrote JRefactory to discover\nhow people use refactorings.  While you have\nused this tool, it has created a log of which\nrefactorings you used.  This log contains a\nnumber representing the refactoring and a date.\n\nI would really appreciate it if you could e-mail\nthe following file to seguin@acm.org.\n\n" + logFile.toString() + "\n" + "\n" + "Thank you for taking the time to do this.\n";
                    JOptionPane.showMessageDialog(null, message, "Research request", 3);
                }
            }
        }
        catch (IOException ioe) {
            ExceptionPrinter.print(ioe, false);
        }
        if (this.refactory) {
            this.jsdkStubInstall();
        }
    }

    private void prettySettings(PrintWriter printer, double version) {
        PrettyPrinterConfigGUI gui = new PrettyPrinterConfigGUI(false);
        gui.initializeFrame(false);
        gui.save();
        FileSettings.getRefactoryPrettySettings().setReloadNow(true);
    }

    private void vssSettings(PrintWriter printer) {
        printer.println("#  This is the full path the visual source safe's executable ");
        printer.println("vss=c:\\\\program files\\\\microsoft visual studio\\\\win32\\\\ss.exe");
        printer.println(" ");
        printer.println("#  The following are the extensions of files which are");
        printer.println("#  stored in visual source safe");
        printer.println("extension.1=.java");
        printer.println("extension.2=.properties");
        printer.println("extension.3=.xml");
        printer.println("extension.4=.html");
        printer.println("extension.5=.htm");
        printer.println(" ");
        printer.println("#  The following shows how the projects in Visual Source");
        printer.println("#  Safe map to directories on the hard disk");
        printer.println("source.1=c:\\\\java\\\\src");
        printer.println("project.1=$/Source");
        printer.println(" ");
        printer.println("source.2=c:\\\\java\\\\properties");
        printer.println("project.2=$/Properties");
        printer.println(" ");
        printer.println("source.3=c:\\\\public_html");
        printer.println("project.3=$/HTML");
        printer.println(" ");
        printer.println("source.4=c:\\\\public_html\\\\xml");
        printer.println("project.4=$/XML");
    }

    private void processSettings(PrintWriter printer) {
        printer.println("#  The following settings are used to set");
        printer.println("#  up the process panel.");
        printer.println("#");
        printer.println("#  The button.name is the value that appears on the button");
        printer.println("#  The button.cmd is the value that is saved to the process");
        printer.println("#      tracking file");
        printer.println("#");
        printer.println("#  The system loads all properties starting with index 0");
        printer.println("#  and continuing until one or both of the next pair of");
        printer.println("#  values is missing.");
        printer.println(" ");
        printer.println("button.name.0=Design");
        printer.println("button.cmd.0=Design");
        printer.println(" ");
        printer.println("button.name.1=Coding");
        printer.println("button.cmd.1=Coding");
        printer.println(" ");
        printer.println("button.name.2=Unit Testing");
        printer.println("button.cmd.2=Unit Testing");
        printer.println(" ");
        printer.println("button.name.3=Verification");
        printer.println("button.cmd.3=Verification");
        printer.println(" ");
        printer.println("button.name.4=Meeting");
        printer.println("button.cmd.4=Meeting");
        printer.println(" ");
        printer.println("button.name.5=Interrupt");
        printer.println("button.cmd.5=Interrupt");
        printer.println(" ");
        printer.println("#  The name of the file to store the process data in");
        printer.println("process.file=c:\\tools\\process.txt");
    }

    private void umlSettings(PrintWriter printer, double version, File dir) {
        if (version < 1.15) {
            printer.println("");
            printer.println("#  UML File Version");
            printer.println("version=1.2");
            printer.println("");
        }
        if (version < 0.95) {
            printer.println("#  The following settings are used to set");
            printer.println("#  up the uml diagrams.");
            printer.println("");
            printer.println("#");
            printer.println("#  The directory containing the stub files");
            printer.println("#");
            printer.println("stub.dir=" + this.doubleBackslashes(dir.getPath()));
            printer.println("");
            printer.println("#");
            printer.println("#  Size of the box where a segmented line changes direction");
            printer.println("#");
            printer.println("sticky.point.size=3");
            printer.println("");
            printer.println("#");
            printer.println("#  Size of the area where you must be to select the sticky point");
            printer.println("#");
            printer.println("halo.size=6");
            printer.println("");
            printer.println("#");
            printer.println("#  The type of icon for the UML diagram.  The valid types are:");
            printer.println("#    colored circle - the original for specifying scope");
            printer.println("#    letter - a letter + for public, # for protected, etc");
            printer.println("#");
            printer.println("icon.type=colored circle");
            printer.println("");
        }
        if (version < 1.05) {
            printer.println("#");
            printer.println("#  A pattern to cause the loading to skip");
            printer.println("#  a particular directory.  For instance,");
            printer.println("#  .cvs means that JRefactory will skip loading");
            printer.println("#  any directory that matches *.cvs*.  Additional");
            printer.println("#  patterns can be separated by the path separator");
            printer.println("#  character");
            printer.println("#");
            printer.println("skip.dir=");
            printer.println("");
            printer.println("#  The extension to add to the existing file when it is");
            printer.println("#  refactored.  The # represents the number of the copy");
            printer.println("#  of the file");
            printer.println("#");
            printer.println("backup.ext=.#");
            printer.println("");
        }
        if (version < 1.15) {
            printer.println("#");
            printer.println("#  This is used by the command line version");
            printer.println("#  of the program to launch a source code editor");
            printer.println("#  The command line program can get either 1 or ");
            printer.println("#  2 arguments.  These are:");
            printer.println("#     $FILE - the path to the file for the editor");
            printer.println("#     $LINE - the line number");
            printer.println("#  If your editor cannot accept the line number");
            printer.println("#  command line, leave out that variable");
            printer.println("#");
            printer.println("#source.editor=notepad $FILE");
            printer.println("#source.editor=gnuclientw -F +$LINE $FILE");
        }
    }

    private void jsdkStubInstall() {
        File outFile;
        File directory;
        FileSettings bundle = FileSettings.getRefactoryPrettySettings();
        bundle.setContinuallyReload(true);
        try {
            FileSettings umlBundle = FileSettings.getRefactorySettings("uml");
            directory = new File(umlBundle.getString("stub.dir") + File.separator + ".Refactory");
        }
        catch (MissingSettingsException mse) {
            directory = FileSettings.getRefactorySettingsRoot();
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(outFile = new File(directory, "JDK.stub")).exists()) {
            new StubPrompter(null, outFile, true).setVisible(true);
        }
        bundle.setContinuallyReload(false);
    }

    private String doubleBackslashes(String value) {
        StringBuffer buffer = new StringBuffer();
        int last = value.length();
        int ndx = 0;
        while (ndx < last) {
            char ch = value.charAt(ndx);
            if (ch == '\\') {
                buffer.append("\\\\");
            } else {
                buffer.append(ch);
            }
            ++ndx;
        }
        return buffer.toString();
    }

    private void generateCreationText(File file) throws IOException {
        FileWriter output = new FileWriter(file);
        PrintWriter printer = new PrintWriter(output);
        printer.println("Created on " + DateFormat.getDateTimeInstance().format(new Date()));
        printer.close();
        output.close();
    }

    public static void main(String[] args) {
        new RefactoryInstaller(false).run();
    }

    static {
        PRETTY_CURRENT_VERSION = 3.8;
        UML_CURRENT_VERSION = 1.2;
    }
}

